/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2.providers;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth;
import io.vertx.core.http.HttpClientOptions;

/**
 * Simplified factory to create an  for Instagram.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.InstagramAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.auth.oauth2.providers.InstagramAuth.class)
public class InstagramAuth {

  public static final io.vertx.lang.rxjava.TypeArg<InstagramAuth> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new InstagramAuth((io.vertx.ext.auth.oauth2.providers.InstagramAuth) obj),
    InstagramAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.InstagramAuth delegate;
  
  public InstagramAuth(io.vertx.ext.auth.oauth2.providers.InstagramAuth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.InstagramAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Instagram
   * @param vertx 
   * @param clientId the client id given to you by Instagram
   * @param clientSecret the client secret given to you by Instagram
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.InstagramAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Instagram
   * @param vertx 
   * @param clientId the client id given to you by Instagram
   * @param clientSecret the client secret given to you by Instagram
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.InstagramAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }


  public static  InstagramAuth newInstance(io.vertx.ext.auth.oauth2.providers.InstagramAuth arg) {
    return arg != null ? new InstagramAuth(arg) : null;
  }
}
