/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.auth.oauth2;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.ext.auth.AuthProvider;
import io.vertx.reactivex.ext.auth.oauth2.AccessToken;

@RxGen(value=io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth
extends AuthProvider {
    public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg(obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth)obj), OAuth2Auth::getDelegate);
    private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;

    public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
        super((io.vertx.ext.auth.AuthProvider)delegate);
        this.delegate = delegate;
    }

    public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
        return this.delegate;
    }

    public static OAuth2Auth createKeycloak(Vertx vertx, OAuth2FlowType flow, JsonObject config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.createKeycloak(vertx.getDelegate(), flow, config));
        return ret;
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow, OAuth2ClientOptions config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow, config));
        return ret;
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow));
        return ret;
    }

    public String authorizeURL(JsonObject params) {
        String ret = this.delegate.authorizeURL(params);
        return ret;
    }

    public void getToken(JsonObject params, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.getToken(params, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<AccessToken> rxGetToken(JsonObject params) {
        return new AsyncResultSingle(handler -> this.getToken(params, (Handler<AsyncResult<AccessToken>>)handler));
    }

    public OAuth2Auth api(HttpMethod method, String path, JsonObject params, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.api(method, path, params, handler);
        return this;
    }

    public Single<JsonObject> rxApi(HttpMethod method, String path, JsonObject params) {
        return new AsyncResultSingle(handler -> this.api(method, path, params, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public boolean hasJWTToken() {
        boolean ret = this.delegate.hasJWTToken();
        return ret;
    }

    public OAuth2Auth decodeToken(String token, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.decodeToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<AccessToken> rxDecodeToken(String token) {
        return new AsyncResultSingle(handler -> this.decodeToken(token, (Handler<AsyncResult<AccessToken>>)handler));
    }

    public OAuth2Auth introspectToken(String token, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.introspectToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<AccessToken> rxIntrospectToken(String token) {
        return new AsyncResultSingle(handler -> this.introspectToken(token, (Handler<AsyncResult<AccessToken>>)handler));
    }

    public OAuth2Auth introspectToken(String token, String tokenType, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.introspectToken(token, tokenType, handler);
        return this;
    }

    public Single<JsonObject> rxIntrospectToken(String token, String tokenType) {
        return new AsyncResultSingle(handler -> this.introspectToken(token, tokenType, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public String getScopeSeparator() {
        String ret = this.delegate.getScopeSeparator();
        return ret;
    }

    public OAuth2FlowType getFlowType() {
        OAuth2FlowType ret = this.delegate.getFlowType();
        return ret;
    }

    public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
        return arg != null ? new OAuth2Auth(arg) : null;
    }
}

