/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.ext.auth.User;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.rxjava.ext.auth.AuthProvider;

/**
 * AccessToken extension to the User interface
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.AccessToken original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken extends User {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AccessToken that = (AccessToken) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<AccessToken> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken) obj),
    AccessToken::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.AccessToken delegate;
  
  public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
    return delegate;
  }

  /**
   * Check if the access token is expired or not.
   * @return 
   */
  public boolean expired() { 
    boolean ret = delegate.expired();
    return ret;
  }

  /**
   * The Access Token if present parsed as a JsonObject
   * @return JSON
   */
  public JsonObject accessToken() { 
    JsonObject ret = delegate.accessToken();
    return ret;
  }

  /**
   * Refresh the access token
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken refresh(Handler<AsyncResult<Void>> callback) { 
    delegate.refresh(callback);
    return this;
  }

  /**
   * Refresh the access token
   * @return 
   * @deprecated use {@link #rxRefresh} instead
   */
  @Deprecated()
  public Observable<Void> refreshObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    refresh(callback.toHandler());
    return callback;
  }

  /**
   * Refresh the access token
   * @return 
   */
  public Single<Void> rxRefresh() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      refresh(fut);
    }));
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken revoke(String token_type, Handler<AsyncResult<Void>> callback) { 
    delegate.revoke(token_type, callback);
    return this;
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   * @deprecated use {@link #rxRevoke} instead
   */
  @Deprecated()
  public Observable<Void> revokeObservable(String token_type) { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    revoke(token_type, callback.toHandler());
    return callback;
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public Single<Void> rxRevoke(String token_type) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      revoke(token_type, fut);
    }));
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken logout(Handler<AsyncResult<Void>> callback) { 
    delegate.logout(callback);
    return this;
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @return 
   * @deprecated use {@link #rxLogout} instead
   */
  @Deprecated()
  public Observable<Void> logoutObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    logout(callback.toHandler());
    return callback;
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @return 
   */
  public Single<Void> rxLogout() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      logout(fut);
    }));
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken introspect(Handler<AsyncResult<Void>> callback) { 
    delegate.introspect(callback);
    return this;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @return 
   * @deprecated use {@link #rxIntrospect} instead
   */
  @Deprecated()
  public Observable<Void> introspectObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    introspect(callback.toHandler());
    return callback;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @return 
   */
  public Single<Void> rxIntrospect() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      introspect(fut);
    }));
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken introspect(String tokenType, Handler<AsyncResult<Void>> callback) { 
    delegate.introspect(tokenType, callback);
    return this;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   * @deprecated use {@link #rxIntrospect} instead
   */
  @Deprecated()
  public Observable<Void> introspectObservable(String tokenType) { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    introspect(tokenType, callback.toHandler());
    return callback;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public Single<Void> rxIntrospect(String tokenType) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      introspect(tokenType, fut);
    }));
  }

  /**
   * Load the user info as per OIDC spec.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken userInfo(Handler<AsyncResult<JsonObject>> callback) { 
    delegate.userInfo(callback);
    return this;
  }

  /**
   * Load the user info as per OIDC spec.
   * @return 
   * @deprecated use {@link #rxUserInfo} instead
   */
  @Deprecated()
  public Observable<JsonObject> userInfoObservable() { 
    io.vertx.rx.java.ObservableFuture<JsonObject> callback = io.vertx.rx.java.RxHelper.observableFuture();
    userInfo(callback.toHandler());
    return callback;
  }

  /**
   * Load the user info as per OIDC spec.
   * @return 
   */
  public Single<JsonObject> rxUserInfo() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      userInfo(fut);
    }));
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken fetch(String resource, Handler<AsyncResult<OAuth2Response>> callback) { 
    delegate.fetch(resource, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
        if (ar.succeeded()) {
          callback.handle(io.vertx.core.Future.succeededFuture(OAuth2Response.newInstance(ar.result())));
        } else {
          callback.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @return 
   * @deprecated use {@link #rxFetch} instead
   */
  @Deprecated()
  public Observable<OAuth2Response> fetchObservable(String resource) { 
    io.vertx.rx.java.ObservableFuture<OAuth2Response> callback = io.vertx.rx.java.RxHelper.observableFuture();
    fetch(resource, callback.toHandler());
    return callback;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @return 
   */
  public Single<OAuth2Response> rxFetch(String resource) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      fetch(resource, fut);
    }));
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload, Handler<AsyncResult<OAuth2Response>> callback) { 
    delegate.fetch(method, resource, headers, payload.getDelegate(), new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
        if (ar.succeeded()) {
          callback.handle(io.vertx.core.Future.succeededFuture(OAuth2Response.newInstance(ar.result())));
        } else {
          callback.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @return 
   * @deprecated use {@link #rxFetch} instead
   */
  @Deprecated()
  public Observable<OAuth2Response> fetchObservable(HttpMethod method, String resource, JsonObject headers, Buffer payload) { 
    io.vertx.rx.java.ObservableFuture<OAuth2Response> callback = io.vertx.rx.java.RxHelper.observableFuture();
    fetch(method, resource, headers, payload, callback.toHandler());
    return callback;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @return 
   */
  public Single<OAuth2Response> rxFetch(HttpMethod method, String resource, JsonObject headers, Buffer payload) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      fetch(method, resource, headers, payload, fut);
    }));
  }


  public static  AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
    return arg != null ? new AccessToken(arg) : null;
  }
}
