/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.impl.AuthProviderInternal;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;

@VertxGen
public interface OAuth2Auth
extends AuthProviderInternal {
    default public void verifyIsUsingPassword() {
        if (this.getFlowType() != OAuth2FlowType.PASSWORD) {
            throw new IllegalArgumentException("OAuth2Auth + Basic Auth requires OAuth2 PASSWORD flow");
        }
    }

    @Deprecated
    public static OAuth2Auth createKeycloak(Vertx vertx, OAuth2FlowType flow, JsonObject config) {
        OAuth2ClientOptions options = new OAuth2ClientOptions();
        if (config.containsKey("auth-server-url")) {
            options.setSite(config.getString("auth-server-url"));
        }
        if (config.containsKey("resource")) {
            options.setClientID(config.getString("resource"));
        }
        if (config.containsKey("credentials") && config.getJsonObject("credentials").containsKey("secret")) {
            options.setClientSecret(config.getJsonObject("credentials").getString("secret"));
        }
        if (config.containsKey("public-client") && config.getBoolean("public-client", Boolean.valueOf(false)).booleanValue()) {
            options.setUseBasicAuthorizationHeader(true);
        }
        if (config.containsKey("realm")) {
            String realm = config.getString("realm");
            options.setAuthorizationPath("/realms/" + realm + "/protocol/openid-connect/auth");
            options.setTokenPath("/realms/" + realm + "/protocol/openid-connect/token");
            options.setRevocationPath(null);
            options.setLogoutPath("/realms/" + realm + "/protocol/openid-connect/logout");
            options.setUserInfoPath("/realms/" + realm + "/protocol/openid-connect/userinfo");
        }
        if (config.containsKey("realm-public-key")) {
            options.setPubSecKeyOptions(new PubSecKeyOptions().setType("RS256").setPublicKey(config.getString("realm-public-key")));
            options.setJwtToken(true);
        }
        return new OAuth2AuthProviderImpl(vertx, flow, options);
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow, OAuth2ClientOptions config) {
        return new OAuth2AuthProviderImpl(vertx, flow, config);
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow) {
        return new OAuth2AuthProviderImpl(vertx, flow, new OAuth2ClientOptions());
    }

    public String authorizeURL(JsonObject var1);

    @Deprecated
    public void getToken(JsonObject var1, Handler<AsyncResult<AccessToken>> var2);

    public boolean hasJWTToken();

    @Fluent
    public OAuth2Auth decodeToken(String var1, Handler<AsyncResult<AccessToken>> var2);

    @Fluent
    default public OAuth2Auth introspectToken(String token, Handler<AsyncResult<AccessToken>> handler) {
        return this.introspectToken(token, "access_token", handler);
    }

    @Fluent
    public OAuth2Auth introspectToken(String var1, String var2, Handler<AsyncResult<AccessToken>> var3);

    public String getScopeSeparator();

    public OAuth2FlowType getFlowType();
}

