/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.auth.oauth2;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.ext.auth.User;
import io.vertx.rxjava.ext.auth.oauth2.OAuth2Response;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken
extends User {
    public static final TypeArg<AccessToken> __TYPE_ARG = new TypeArg(obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken)obj), AccessToken::getDelegate);
    private final io.vertx.ext.auth.oauth2.AccessToken delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)((Object)o);
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
        super((io.vertx.ext.auth.User)delegate);
        this.delegate = delegate;
    }

    public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
        return this.delegate;
    }

    public boolean expired() {
        boolean ret = this.delegate.expired();
        return ret;
    }

    public JsonObject accessToken() {
        JsonObject ret = this.delegate.accessToken();
        return ret;
    }

    public AccessToken refresh(Handler<AsyncResult<Void>> callback) {
        this.delegate.refresh(callback);
        return this;
    }

    @Deprecated
    public Observable<Void> refreshObservable() {
        ObservableFuture callback = RxHelper.observableFuture();
        this.refresh((Handler<AsyncResult<Void>>)callback.toHandler());
        return callback;
    }

    public Single<Void> rxRefresh() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.refresh((Handler<AsyncResult<Void>>)fut)));
    }

    public AccessToken revoke(String token_type, Handler<AsyncResult<Void>> callback) {
        this.delegate.revoke(token_type, callback);
        return this;
    }

    @Deprecated
    public Observable<Void> revokeObservable(String token_type) {
        ObservableFuture callback = RxHelper.observableFuture();
        this.revoke(token_type, (Handler<AsyncResult<Void>>)callback.toHandler());
        return callback;
    }

    public Single<Void> rxRevoke(String token_type) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.revoke(token_type, (Handler<AsyncResult<Void>>)fut)));
    }

    public AccessToken logout(Handler<AsyncResult<Void>> callback) {
        this.delegate.logout(callback);
        return this;
    }

    @Deprecated
    public Observable<Void> logoutObservable() {
        ObservableFuture callback = RxHelper.observableFuture();
        this.logout((Handler<AsyncResult<Void>>)callback.toHandler());
        return callback;
    }

    public Single<Void> rxLogout() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.logout((Handler<AsyncResult<Void>>)fut)));
    }

    public AccessToken introspect(Handler<AsyncResult<Void>> callback) {
        this.delegate.introspect(callback);
        return this;
    }

    @Deprecated
    public Observable<Void> introspectObservable() {
        ObservableFuture callback = RxHelper.observableFuture();
        this.introspect((Handler<AsyncResult<Void>>)callback.toHandler());
        return callback;
    }

    public Single<Void> rxIntrospect() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.introspect((Handler<AsyncResult<Void>>)fut)));
    }

    public AccessToken introspect(String tokenType, Handler<AsyncResult<Void>> callback) {
        this.delegate.introspect(tokenType, callback);
        return this;
    }

    @Deprecated
    public Observable<Void> introspectObservable(String tokenType) {
        ObservableFuture callback = RxHelper.observableFuture();
        this.introspect(tokenType, (Handler<AsyncResult<Void>>)callback.toHandler());
        return callback;
    }

    public Single<Void> rxIntrospect(String tokenType) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.introspect(tokenType, (Handler<AsyncResult<Void>>)fut)));
    }

    public AccessToken userInfo(Handler<AsyncResult<JsonObject>> callback) {
        this.delegate.userInfo(callback);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> userInfoObservable() {
        ObservableFuture callback = RxHelper.observableFuture();
        this.userInfo((Handler<AsyncResult<JsonObject>>)callback.toHandler());
        return callback;
    }

    public Single<JsonObject> rxUserInfo() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.userInfo((Handler<AsyncResult<JsonObject>>)fut)));
    }

    public AccessToken fetch(String resource, final Handler<AsyncResult<OAuth2Response>> callback) {
        this.delegate.fetch(resource, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<OAuth2Response> fetchObservable(String resource) {
        ObservableFuture callback = RxHelper.observableFuture();
        this.fetch(resource, (Handler<AsyncResult<OAuth2Response>>)callback.toHandler());
        return callback;
    }

    public Single<OAuth2Response> rxFetch(String resource) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.fetch(resource, (Handler<AsyncResult<OAuth2Response>>)fut)));
    }

    public AccessToken fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload, final Handler<AsyncResult<OAuth2Response>> callback) {
        this.delegate.fetch(method, resource, headers, payload.getDelegate(), new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<OAuth2Response> fetchObservable(HttpMethod method, String resource, JsonObject headers, Buffer payload) {
        ObservableFuture callback = RxHelper.observableFuture();
        this.fetch(method, resource, headers, payload, (Handler<AsyncResult<OAuth2Response>>)callback.toHandler());
        return callback;
    }

    public Single<OAuth2Response> rxFetch(HttpMethod method, String resource, JsonObject headers, Buffer payload) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.fetch(method, resource, headers, payload, (Handler<AsyncResult<OAuth2Response>>)fut)));
    }

    public static AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
        return arg != null ? new AccessToken(arg) : null;
    }
}

