/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Response;

public class OAuth2ResponseImpl
implements OAuth2Response {
    private final int statusCode;
    private final MultiMap headers;
    private final Buffer body;

    public OAuth2ResponseImpl(int statusCode, MultiMap headers, Buffer body) {
        this.headers = headers;
        this.body = body;
        this.statusCode = statusCode;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String getHeader(String header) {
        if (this.headers != null) {
            return this.headers.get(header);
        }
        return null;
    }

    @Override
    public Buffer body() {
        return this.body;
    }

    @Override
    public JsonObject jsonObject() {
        return new JsonObject(this.body.toString());
    }

    @Override
    public JsonArray jsonArray() {
        return new JsonArray(this.body.toString());
    }

    @Override
    public boolean is(String contentType) {
        String header;
        if (this.headers != null && (header = this.headers.get("Content-Type")) != null) {
            int sep = header.indexOf(59);
            if (sep != -1) {
                header = header.substring(0, sep).trim();
            }
            if (contentType.equals(header)) {
                return true;
            }
        }
        return false;
    }
}

