/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2.providers;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth;
import io.vertx.core.http.HttpClientOptions;

/**
 * Simplified factory to create an  for Azure AD.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.AzureADAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.auth.oauth2.providers.AzureADAuth.class)
public class AzureADAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AzureADAuth that = (AzureADAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<AzureADAuth> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new AzureADAuth((io.vertx.ext.auth.oauth2.providers.AzureADAuth) obj),
    AzureADAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.AzureADAuth delegate;
  
  public AzureADAuth(io.vertx.ext.auth.oauth2.providers.AzureADAuth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.AzureADAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Microsoft Azure Active Directory
   * @param vertx 
   * @param clientId the client id given to you by Azure
   * @param clientSecret the client secret given to you by Azure
   * @param guid the guid of your application given to you by Azure
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String guid) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.AzureADAuth.create(vertx.getDelegate(), clientId, clientSecret, guid));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Microsoft Azure Active Directory
   * @param vertx 
   * @param clientId the client id given to you by Azure
   * @param clientSecret the client secret given to you by Azure
   * @param guid the guid of your application given to you by Azure
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String guid, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.AzureADAuth.create(vertx.getDelegate(), clientId, clientSecret, guid, httpClientOptions));
    return ret;
  }


  public static  AzureADAuth newInstance(io.vertx.ext.auth.oauth2.providers.AzureADAuth arg) {
    return arg != null ? new AzureADAuth(arg) : null;
  }
}
