/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.providers;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth;
import io.vertx.core.http.HttpClientOptions;

/**
 * Simplified factory to create an  for Mailchimp.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.MailchimpAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.auth.oauth2.providers.MailchimpAuth.class)
public class MailchimpAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailchimpAuth that = (MailchimpAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<MailchimpAuth> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new MailchimpAuth((io.vertx.ext.auth.oauth2.providers.MailchimpAuth) obj),
    MailchimpAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.MailchimpAuth delegate;
  
  public MailchimpAuth(io.vertx.ext.auth.oauth2.providers.MailchimpAuth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.MailchimpAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Mailchimp
   * @param vertx 
   * @param clientId the client id given to you by Mailchimp
   * @param clientSecret the client secret given to you by Mailchimp
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.MailchimpAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Mailchimp
   * @param vertx 
   * @param clientId the client id given to you by Mailchimp
   * @param clientSecret the client secret given to you by Mailchimp
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.MailchimpAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }


  public static  MailchimpAuth newInstance(io.vertx.ext.auth.oauth2.providers.MailchimpAuth arg) {
    return arg != null ? new MailchimpAuth(arg) : null;
  }
}
