/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.ext.auth.impl.AuthProviderInternal;
import io.vertx.core.Handler;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;

/**
 * Factory interface for creating OAuth2 based {@link io.vertx.reactivex.ext.auth.AuthProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.OAuth2Auth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2Auth that = (OAuth2Auth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<OAuth2Auth> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth) obj),
    OAuth2Auth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;
  
  public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
    return delegate;
  }

  public void verifyIsUsingPassword() { 
    delegate.verifyIsUsingPassword();
  }

  /**
   * @param vertx the Vertx instance
   * @param flow 
   * @param config the config as exported from the admin console
   * @return the auth provider
   */
  public static OAuth2Auth createKeycloak(Vertx vertx, OAuth2FlowType flow, JsonObject config) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.createKeycloak(vertx.getDelegate(), flow, config));
    return ret;
  }

  /**
   * Create a OAuth2 auth provider
   * @param vertx the Vertx instance
   * @param flow 
   * @param config the config
   * @return the auth provider
   */
  public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow, OAuth2ClientOptions config) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow, config));
    return ret;
  }

  /**
   * Create a OAuth2 auth provider
   * @param vertx the Vertx instance
   * @param flow 
   * @return the auth provider
   */
  public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow));
    return ret;
  }

  /**
   * Generate a redirect URL to the authN/Z backend. It only applies to auth_code flow.
   * @param params 
   * @return 
   */
  public String authorizeURL(JsonObject params) { 
    String ret = delegate.authorizeURL(params);
    return ret;
  }

  /**
   * Returns the Access Token object.
   * @param params - JSON with the options, each flow requires different options.
   * @param handler - The handler returning the results.
   */
  public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) { 
    delegate.getToken(params, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(AccessToken.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Returns the Access Token object.
   * @param params - JSON with the options, each flow requires different options.
   * @return 
   */
  public Single<AccessToken> rxGetToken(JsonObject params) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<AccessToken>(handler -> {
      getToken(params, handler);
    });
  }

  /**
   * Returns true if this provider supports JWT tokens as the access_token. This is typically true if the provider
   * implements the `openid-connect` protocol. This is a plain return from the config option jwtToken, which is false
   * by default.
   *
   * This information is important to validate grants. Since pure OAuth2 should be used for authorization and when a
   * token is requested all grants should be declared, in case of openid-connect this is not true. OpenId will issue
   * a token and all grants will be encoded on the token itself so the requester does not need to list the required
   * grants.
   * @return true if openid-connect is used.
   */
  public boolean hasJWTToken() { 
    boolean ret = delegate.hasJWTToken();
    return ret;
  }

  /**
   * Decode a token to a {@link io.vertx.reactivex.ext.auth.oauth2.AccessToken} object. This is useful to handle bearer JWT tokens.
   * @param token the access token (base64 string)
   * @param handler A handler to receive the event
   * @return self
   */
  public OAuth2Auth decodeToken(String token, Handler<AsyncResult<AccessToken>> handler) { 
    delegate.decodeToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(AccessToken.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Decode a token to a {@link io.vertx.reactivex.ext.auth.oauth2.AccessToken} object. This is useful to handle bearer JWT tokens.
   * @param token the access token (base64 string)
   * @return 
   */
  public Single<AccessToken> rxDecodeToken(String token) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<AccessToken>(handler -> {
      decodeToken(token, handler);
    });
  }

  /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @param handler A handler to receive the event
   * @return self
   */
  public OAuth2Auth introspectToken(String token, Handler<AsyncResult<AccessToken>> handler) { 
    delegate.introspectToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(AccessToken.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @return 
   */
  public Single<AccessToken> rxIntrospectToken(String token) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<AccessToken>(handler -> {
      introspectToken(token, handler);
    });
  }

  /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @param tokenType hint to the token type e.g.: `access_token`
   * @param handler A handler to receive the event
   * @return self
   */
  public OAuth2Auth introspectToken(String token, String tokenType, Handler<AsyncResult<AccessToken>> handler) { 
    delegate.introspectToken(token, tokenType, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(AccessToken.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @param tokenType hint to the token type e.g.: `access_token`
   * @return 
   */
  public Single<AccessToken> rxIntrospectToken(String token, String tokenType) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<AccessToken>(handler -> {
      introspectToken(token, tokenType, handler);
    });
  }

  /**
   * Returns the scope separator.
   *
   * The RFC 6749 states that a scope is expressed as a set of case-sensitive and space-delimited strings, however
   * vendors tend not to agree on this and we see the following cases being used: space, plus sign, comma.
   * @return what value was used in the configuration of the object, falling back to the default value which is a space.
   */
  public String getScopeSeparator() { 
    String ret = delegate.getScopeSeparator();
    return ret;
  }

  /**
   * Returns the configured flow type for the Oauth2 provider.
   * @return the flow type.
   */
  public OAuth2FlowType getFlowType() { 
    OAuth2FlowType ret = delegate.getFlowType();
    return ret;
  }

  /**
   * Loads a JWK Set from the remote provider.
   *
   * When calling this method several times, the loaded JWKs are updated in the underlying JWT object.
   * @param handler 
   * @return 
   */
  public OAuth2Auth loadJWK(Handler<AsyncResult<Void>> handler) { 
    delegate.loadJWK(handler);
    return this;
  }

  /**
   * Loads a JWK Set from the remote provider.
   *
   * When calling this method several times, the loaded JWKs are updated in the underlying JWT object.
   * @return 
   */
  public Completable rxLoadJWK() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      loadJWK(handler);
    });
  }


  public static  OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
    return arg != null ? new OAuth2Auth(arg) : null;
  }
}
