/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2.providers;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth;
import io.vertx.core.http.HttpClientOptions;

/**
 * Simplified factory to create an {@link io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth} for Google.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.GoogleAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.auth.oauth2.providers.GoogleAuth.class)
public class GoogleAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GoogleAuth that = (GoogleAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<GoogleAuth> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new GoogleAuth((io.vertx.ext.auth.oauth2.providers.GoogleAuth) obj),
    GoogleAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.GoogleAuth delegate;
  
  public GoogleAuth(io.vertx.ext.auth.oauth2.providers.GoogleAuth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.GoogleAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Google
   * @param vertx 
   * @param clientId the client id given to you by Google
   * @param clientSecret the client secret given to you by Google
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Google
   * @param vertx 
   * @param clientId the client id given to you by Google
   * @param clientSecret the client secret given to you by Google
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Google Service Account (Server to Server)
   * @param vertx 
   * @param serviceAccountJson the configuration json file from your Google API page
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, JsonObject serviceAccountJson) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), serviceAccountJson));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Google Service Account (Server to Server)
   * @param vertx 
   * @param serviceAccountJson the configuration json file from your Google API page
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, JsonObject serviceAccountJson, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), serviceAccountJson, httpClientOptions));
    return ret;
  }


  public static  GoogleAuth newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth arg) {
    return arg != null ? new GoogleAuth(arg) : null;
  }
}
