/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2.providers;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth;
import io.vertx.core.http.HttpClientOptions;

/**
 * Simplified factory to create an  for SoundCloud.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.SoundcloudAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.auth.oauth2.providers.SoundcloudAuth.class)
public class SoundcloudAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SoundcloudAuth that = (SoundcloudAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<SoundcloudAuth> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new SoundcloudAuth((io.vertx.ext.auth.oauth2.providers.SoundcloudAuth) obj),
    SoundcloudAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.SoundcloudAuth delegate;
  
  public SoundcloudAuth(io.vertx.ext.auth.oauth2.providers.SoundcloudAuth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.SoundcloudAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for SoundCloud
   * @param vertx 
   * @param clientId the client id given to you by SoundCloud
   * @param clientSecret the client secret given to you by SoundCloud
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.SoundcloudAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for SoundCloud
   * @param vertx 
   * @param clientId the client id given to you by SoundCloud
   * @param clientSecret the client secret given to you by SoundCloud
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.SoundcloudAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }


  public static  SoundcloudAuth newInstance(io.vertx.ext.auth.oauth2.providers.SoundcloudAuth arg) {
    return arg != null ? new SoundcloudAuth(arg) : null;
  }
}
