/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import java.util.Map;
import java.util.Objects;

@DataObject
public class Oauth2Credentials
extends UsernamePasswordCredentials {
    private String accessToken;
    private String code;
    private String redirectUri;
    private JsonObject extra;

    public Oauth2Credentials() {
    }

    public Oauth2Credentials(JsonObject jsonObject) {
        super(jsonObject);
        block10: for (Map.Entry member : jsonObject) {
            switch ((String)member.getKey()) {
                case "access_token": {
                    if (!(member.getValue() instanceof String)) continue block10;
                    this.setAccessToken((String)member.getValue());
                    continue block10;
                }
                case "code": {
                    if (!(member.getValue() instanceof String)) continue block10;
                    this.setCode((String)member.getValue());
                    continue block10;
                }
                case "redirect_uri": {
                    if (!(member.getValue() instanceof String)) continue block10;
                    this.setRedirectUri((String)member.getValue());
                    continue block10;
                }
            }
            if (this.extra == null) {
                this.extra = new JsonObject();
            }
            this.extra.put((String)member.getKey(), member.getValue());
        }
    }

    public Oauth2Credentials setPassword(String password) {
        super.setPassword(password);
        return this;
    }

    public Oauth2Credentials setUsername(String username) {
        super.setUsername(username);
        return this;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Oauth2Credentials setAccessToken(String accessToken) {
        this.accessToken = Objects.requireNonNull(accessToken);
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public Oauth2Credentials setCode(String code) {
        this.code = Objects.requireNonNull(code);
        return this;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Oauth2Credentials setRedirectUri(String redirectUri) {
        this.redirectUri = Objects.requireNonNull(redirectUri);
        return this;
    }

    public JsonObject getExtra() {
        return this.extra;
    }

    public Oauth2Credentials setExtra(JsonObject extra) {
        this.extra = Objects.requireNonNull(extra);
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        if (this.getAccessToken() != null) {
            json.put("access_token", (Object)this.getAccessToken());
        }
        if (this.getCode() != null) {
            json.put("code", (Object)this.getCode());
        }
        if (this.getRedirectUri() != null) {
            json.put("redirect_uri", (Object)this.getRedirectUri());
        }
        if (this.extra != null) {
            json.mergeIn(this.extra);
        }
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

