/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import java.util.Map;

@DataObject
public class Oauth2Credentials
implements Credentials {
    private String code;
    private String redirectUri;
    private JsonObject extra;

    public Oauth2Credentials() {
    }

    public Oauth2Credentials(JsonObject jsonObject) {
        block8: for (Map.Entry member : jsonObject) {
            switch ((String)member.getKey()) {
                case "code": {
                    if (!(member.getValue() instanceof String)) continue block8;
                    this.setCode((String)member.getValue());
                    continue block8;
                }
                case "redirect_uri": {
                    if (!(member.getValue() instanceof String)) continue block8;
                    this.setRedirectUri((String)member.getValue());
                    continue block8;
                }
            }
            if (this.extra == null) {
                this.extra = new JsonObject();
            }
            this.extra.put((String)member.getKey(), member.getValue());
        }
    }

    public String getCode() {
        return this.code;
    }

    public Oauth2Credentials setCode(String code) {
        this.code = code;
        return this;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Oauth2Credentials setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public JsonObject getExtra() {
        return this.extra;
    }

    public Oauth2Credentials setExtra(JsonObject extra) {
        this.extra = extra;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.getCode() != null) {
            json.put("code", (Object)this.getCode());
        }
        if (this.getRedirectUri() != null) {
            json.put("redirect_uri", (Object)this.getRedirectUri());
        }
        if (this.extra != null) {
            json.mergeIn(this.extra);
        }
        return json;
    }

    public <V> void checkValid(V arg) throws CredentialValidationException {
        OAuth2FlowType flow = (OAuth2FlowType)((Object)arg);
        switch (flow) {
            case AUTH_CODE: {
                if (this.code == null || this.code.length() == 0) {
                    throw new CredentialValidationException("code cannot be null or empty");
                }
                if (this.redirectUri != null && this.redirectUri.length() != 0) break;
                throw new CredentialValidationException("redirectUri cannot be null or empty");
            }
        }
    }

    public String toString() {
        return this.toJson().encode();
    }
}

