/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@VertxGen
@Deprecated
public interface KeycloakHelper {
    public static String rawIdToken(JsonObject principal) {
        return principal.getString("id_token");
    }

    public static JsonObject idToken(JsonObject principal) {
        return KeycloakHelper.parseToken(KeycloakHelper.rawIdToken(principal));
    }

    public static String rawAccessToken(JsonObject principal) {
        return principal.getString("access_token");
    }

    public static JsonObject accessToken(JsonObject principal) {
        return KeycloakHelper.parseToken(KeycloakHelper.rawAccessToken(principal));
    }

    public static int authTime(JsonObject principal) {
        return KeycloakHelper.idToken(principal).getInteger("auth_time");
    }

    public static String sessionState(JsonObject principal) {
        return KeycloakHelper.idToken(principal).getString("session_state");
    }

    public static String acr(JsonObject principal) {
        return KeycloakHelper.idToken(principal).getString("acr");
    }

    public static String name(JsonObject principal) {
        return KeycloakHelper.idToken(principal).getString("name");
    }

    public static String email(JsonObject principal) {
        return KeycloakHelper.idToken(principal).getString("email");
    }

    public static String preferredUsername(JsonObject principal) {
        return KeycloakHelper.idToken(principal).getString("preferred_username");
    }

    public static String nickName(JsonObject principal) {
        return KeycloakHelper.idToken(principal).getString("nickname");
    }

    public static Set<String> allowedOrigins(JsonObject principal) {
        List allowedOrigins = KeycloakHelper.accessToken(principal).getJsonArray("allowed-origins").getList();
        return new HashSet<String>(allowedOrigins);
    }

    public static JsonObject parseToken(String token) {
        if (token == null) {
            return null;
        }
        String[] parts = token.split("\\.");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Parsing error");
        }
        try {
            String decoded = new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8);
            return new JsonObject(decoded);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

