/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.authorization.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class ScopeAuthorizationImpl
implements ScopeAuthorization {
    private final String scopeSeparator;

    public ScopeAuthorizationImpl(String scopeSeparator) {
        this.scopeSeparator = scopeSeparator;
    }

    public String getId() {
        return "oauth2-scope";
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
        String scopes = user.principal().getString("scope");
        HashSet<PermissionBasedAuthorization> authorizations = new HashSet<PermissionBasedAuthorization>();
        if (scopes != null) {
            String sep = user.attributes().getString("scope_separator", this.scopeSeparator);
            for (String scope : scopes.split(Pattern.quote(sep))) {
                authorizations.add(PermissionBasedAuthorization.create((String)scope));
            }
        }
        user.authorizations().add(this.getId(), authorizations);
        handler.handle((Object)Future.succeededFuture());
    }

    @Override
    public String separator() {
        return this.scopeSeparator;
    }

    @Override
    public String encode(List<String> scopes) {
        return String.join((CharSequence)this.separator(), scopes);
    }
}

