/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;

@VertxGen
public interface AzureADAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String guid) {
        return AzureADAuth.create(vertx, clientId, clientSecret, guid, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String guid, HttpClientOptions httpClientOptions) {
        return OAuth2Auth.create(vertx, new OAuth2Options().setHttpClientOptions(httpClientOptions).setFlow(OAuth2FlowType.AUTH_CODE).setClientId(clientId).setClientSecret(clientSecret).setTenant(guid).setSite("https://login.microsoftonline.com/{tenant}").setTokenPath("/oauth2/token").setAuthorizationPath("/oauth2/authorize").setJwkPath("/../common/discovery/keys").setJWTOptions(new JWTOptions().setNonceAlgorithm("SHA-256").addAudience(clientId)));
    }

    public static void discover(Vertx vertx, OAuth2Options config, Handler<AsyncResult<OAuth2Auth>> handler) {
        JWTOptions jwtOptions;
        String site = config.getSite() == null ? "https://login.microsoftonline.com/{tenant}" : config.getSite();
        JWTOptions jWTOptions = jwtOptions = config.getJWTOptions() == null ? new JWTOptions() : new JWTOptions(config.getJWTOptions());
        if (jwtOptions.getNonceAlgorithm() == null) {
            jwtOptions.setNonceAlgorithm("SHA-256");
        }
        if (jwtOptions.getAudience() == null || jwtOptions.getAudience().size() == 0) {
            jwtOptions.addAudience(config.getClientId());
        }
        OpenIDConnectAuth.discover(vertx, new OAuth2Options(config).setValidateIssuer(false).setSite(site).setJWTOptions(jwtOptions), handler);
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2Options config) {
        Promise promise = Promise.promise();
        AzureADAuth.discover(vertx, config, (Handler<AsyncResult<OAuth2Auth>>)promise);
        return promise.future();
    }
}

