/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.http.SimpleHttpClient;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.impl.OAuth2Response;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuth2API {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2API.class);
    private static final Pattern MAX_AGE = Pattern.compile("max-age=\"?(\\d+)\"?");
    private final HttpClient client;
    private final OAuth2Options config;

    public OAuth2API(Vertx vertx, OAuth2Options config) {
        this.config = config;
        this.client = vertx.createHttpClient(config.getHttpClientOptions());
    }

    public void jwkSet(Handler<AsyncResult<JsonObject>> handler) {
        JsonObject headers = new JsonObject();
        headers.put("Accept", (Object)"application/jwk-set+json, application/json");
        this.fetch(HttpMethod.GET, this.config.getJwkPath(), headers, null, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            JsonObject json;
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            OAuth2Response reply = (OAuth2Response)res.result();
            if (reply.body() == null || reply.body().length() == 0) {
                handler.handle((Object)Future.failedFuture((String)"No Body"));
                return;
            }
            if (reply.is("application/jwk-set+json") || reply.is("application/json")) {
                try {
                    json = new JsonObject(reply.body());
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else {
                handler.handle((Object)Future.failedFuture((String)("Cannot handle content type: " + reply.headers().get("Content-Type"))));
                return;
            }
            try {
                if (json.containsKey("error")) {
                    handler.handle((Object)Future.failedFuture((String)this.extractErrorDescription(json)));
                } else {
                    List cacheControl = reply.headers().getAll(HttpHeaders.CACHE_CONTROL);
                    if (cacheControl != null) {
                        for (String header : cacheControl) {
                            Matcher match;
                            if (header.length() <= 8 || !(match = MAX_AGE.matcher(header)).find()) continue;
                            try {
                                json.put("maxAge", (Object)Long.valueOf(match.group(1)));
                                break;
                            }
                            catch (RuntimeException runtimeException) {
                            }
                        }
                    }
                    handler.handle((Object)Future.succeededFuture((Object)json));
                }
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }));
    }

    public String authorizeURL(JsonObject params) {
        JsonObject query = params.copy();
        if (this.config.getFlow() != OAuth2FlowType.AUTH_CODE) {
            throw new IllegalStateException("authorization URL cannot be computed for non AUTH_CODE flow");
        }
        if (query.containsKey("scopes")) {
            query.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), query.getJsonArray("scopes").getList()));
            query.remove("scopes");
        }
        query.put("response_type", (Object)"code");
        String clientId = this.config.getClientId();
        if (clientId != null) {
            query.put("client_id", (Object)clientId);
        } else {
            query.put("client_assertion_type", (Object)this.config.getClientAssertionType()).put("client_assertion", (Object)this.config.getClientAssertion());
        }
        String path = this.config.getAuthorizationPath();
        String url = path.charAt(0) == '/' ? this.config.getSite() + path : path;
        return url + '?' + SimpleHttpClient.jsonToQuery((JsonObject)query).toString();
    }

    public void token(String grantType, JsonObject params, Handler<AsyncResult<JsonObject>> handler) {
        boolean confidentialClient;
        if (grantType == null) {
            handler.handle((Object)Future.failedFuture((String)"Token request requires a grantType other than null"));
            return;
        }
        JsonObject headers = new JsonObject();
        boolean bl = confidentialClient = this.config.getClientId() != null && this.config.getClientSecret() != null;
        if (confidentialClient) {
            String basic = this.config.getClientId() + ":" + this.config.getClientSecret();
            headers.put("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString(basic.getBytes(StandardCharsets.UTF_8))));
        }
        JsonObject form = params.copy();
        if (this.config.getExtraParameters() != null) {
            form.mergeIn(this.config.getExtraParameters());
        }
        form.put("grant_type", (Object)grantType);
        if (!confidentialClient) {
            String clientId = this.config.getClientId();
            if (clientId != null) {
                form.put("client_id", (Object)clientId);
            } else {
                form.put("client_assertion_type", (Object)this.config.getClientAssertionType()).put("client_assertion", (Object)this.config.getClientAssertion());
            }
        }
        headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        Buffer payload = SimpleHttpClient.jsonToQuery((JsonObject)form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        this.fetch(HttpMethod.POST, this.config.getTokenPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            JsonObject json;
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            OAuth2Response reply = (OAuth2Response)res.result();
            if (reply.body() == null || reply.body().length() == 0) {
                handler.handle((Object)Future.failedFuture((String)"No Body"));
                return;
            }
            if (reply.is("application/json")) {
                try {
                    json = new JsonObject(reply.body());
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                try {
                    json = SimpleHttpClient.queryToJson((Buffer)reply.body());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else {
                handler.handle((Object)Future.failedFuture((String)("Cannot handle content type: " + reply.headers().get("Content-Type"))));
                return;
            }
            try {
                if (json.containsKey("error")) {
                    handler.handle((Object)Future.failedFuture((String)this.extractErrorDescription(json)));
                } else {
                    OAuth2API.processNonStandardHeaders(json, reply, this.config.getScopeSeparator());
                    handler.handle((Object)Future.succeededFuture((Object)json));
                }
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }));
    }

    public void tokenIntrospection(String tokenType, String token, Handler<AsyncResult<JsonObject>> handler) {
        boolean confidentialClient;
        JsonObject headers = new JsonObject();
        boolean bl = confidentialClient = this.config.getClientId() != null && this.config.getClientSecret() != null;
        if (confidentialClient) {
            String basic = this.config.getClientId() + ":" + this.config.getClientSecret();
            headers.put("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString(basic.getBytes(StandardCharsets.UTF_8))));
        }
        JsonObject form = new JsonObject().put("token", (Object)token).put("token_type_hint", (Object)tokenType);
        headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        Buffer payload = SimpleHttpClient.jsonToQuery((JsonObject)form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        this.fetch(HttpMethod.POST, this.config.getIntrospectionPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            JsonObject json;
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            OAuth2Response reply = (OAuth2Response)res.result();
            if (reply.body() == null || reply.body().length() == 0) {
                handler.handle((Object)Future.failedFuture((String)"No Body"));
                return;
            }
            if (reply.is("application/json")) {
                try {
                    json = new JsonObject(reply.body());
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                try {
                    json = SimpleHttpClient.queryToJson((Buffer)reply.body());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else {
                handler.handle((Object)Future.failedFuture((String)("Cannot handle accessToken type: " + reply.headers().get("Content-Type"))));
                return;
            }
            try {
                if (json.containsKey("error")) {
                    handler.handle((Object)Future.failedFuture((String)this.extractErrorDescription(json)));
                } else {
                    OAuth2API.processNonStandardHeaders(json, reply, this.config.getScopeSeparator());
                    handler.handle((Object)Future.succeededFuture((Object)json));
                }
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }));
    }

    public void tokenRevocation(String tokenType, String token, Handler<AsyncResult<Void>> handler) {
        boolean confidentialClient;
        if (token == null) {
            handler.handle((Object)Future.failedFuture((String)"Cannot revoke null token"));
            return;
        }
        JsonObject headers = new JsonObject();
        boolean bl = confidentialClient = this.config.getClientId() != null && this.config.getClientSecret() != null;
        if (confidentialClient) {
            String basic = this.config.getClientId() + ":" + this.config.getClientSecret();
            headers.put("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString(basic.getBytes(StandardCharsets.UTF_8))));
        }
        JsonObject form = new JsonObject();
        form.put("token", (Object)token).put("token_type_hint", (Object)tokenType);
        headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        Buffer payload = SimpleHttpClient.jsonToQuery((JsonObject)form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        this.fetch(HttpMethod.POST, this.config.getRevocationPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            OAuth2Response reply = (OAuth2Response)res.result();
            if (reply.body() == null) {
                handler.handle((Object)Future.failedFuture((String)"No Body"));
                return;
            }
            handler.handle((Object)Future.succeededFuture());
        }));
    }

    public void userInfo(String accessToken, JWT jwt, Handler<AsyncResult<JsonObject>> handler) {
        JsonObject headers = new JsonObject();
        JsonObject extraParams = this.config.getUserInfoParameters();
        String path = this.config.getUserInfoPath();
        if (path == null) {
            handler.handle((Object)Future.failedFuture((String)"userInfo path is not configured"));
            return;
        }
        if (extraParams != null) {
            path = path + "?" + SimpleHttpClient.jsonToQuery((JsonObject)extraParams).toString();
        }
        headers.put("Authorization", (Object)("Bearer " + accessToken));
        headers.put("Accept", (Object)"application/json,application/jwt,application/x-www-form-urlencoded;q=0.9");
        this.fetch(HttpMethod.GET, path, headers, null, (Handler<AsyncResult<OAuth2Response>>)((Handler)fetch -> {
            JsonObject userInfo;
            if (fetch.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)fetch.cause()));
                return;
            }
            OAuth2Response reply = (OAuth2Response)fetch.result();
            if (reply.is("application/json")) {
                try {
                    userInfo = new JsonObject(reply.body());
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else if (reply.is("application/jwt")) {
                try {
                    userInfo = jwt.decode(reply.body().toString(StandardCharsets.UTF_8));
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                try {
                    userInfo = SimpleHttpClient.queryToJson((Buffer)reply.body());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else {
                handler.handle((Object)Future.failedFuture((String)("Cannot handle Content-Type: " + reply.headers().get("Content-Type"))));
                return;
            }
            OAuth2API.processNonStandardHeaders(userInfo, reply, this.config.getScopeSeparator());
            handler.handle((Object)Future.succeededFuture((Object)userInfo));
        }));
    }

    public String endSessionURL(String idToken, JsonObject params) {
        String path = this.config.getLogoutPath();
        if (path == null) {
            return null;
        }
        JsonObject query = params.copy();
        if (idToken != null) {
            query.put("id_token_hint", (Object)idToken);
        }
        String url = path.charAt(0) == '/' ? this.config.getSite() + path : path;
        return url + '?' + SimpleHttpClient.jsonToQuery((JsonObject)query).toString();
    }

    public void logout(String accessToken, String refreshToken, Handler<AsyncResult<Void>> callback) {
        JsonObject headers = new JsonObject();
        headers.put("Authorization", (Object)("Bearer " + accessToken));
        JsonObject form = new JsonObject();
        form.put("client_id", (Object)this.config.getClientId());
        if (this.config.getClientSecret() != null) {
            form.put("client_secret", (Object)this.config.getClientSecret());
        }
        if (refreshToken != null) {
            form.put("refresh_token", (Object)refreshToken);
        }
        headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        Buffer payload = SimpleHttpClient.jsonToQuery((JsonObject)form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        this.fetch(HttpMethod.POST, this.config.getLogoutPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            if (res.succeeded()) {
                callback.handle((Object)Future.succeededFuture());
            } else {
                callback.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }

    private String extractErrorDescription(JsonObject json) {
        String description;
        Object error = json.getValue("error");
        if (error instanceof JsonObject) {
            description = ((JsonObject)error).getString("message");
        } else {
            try {
                description = json.getString("error_description", json.getString("error"));
            }
            catch (RuntimeException e) {
                description = error.toString();
            }
        }
        return description;
    }

    public void fetch(HttpMethod method, String path, JsonObject headers, Buffer payload, Handler<AsyncResult<OAuth2Response>> callback) {
        if (path == null || path.length() == 0) {
            callback.handle((Object)Future.failedFuture((String)"Invalid path"));
            return;
        }
        String url = path.charAt(0) == '/' ? this.config.getSite() + path : path;
        LOG.debug((Object)("Fetching URL: " + url));
        RequestOptions options = new RequestOptions().setMethod(method).setAbsoluteURI(url);
        JsonObject tmp = this.config.getHeaders();
        if (tmp != null) {
            for (Map.Entry kv : tmp) {
                options.addHeader((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry kv : headers) {
                options.addHeader((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (this.config.getUserAgent() != null) {
            options.addHeader("User-Agent", this.config.getUserAgent());
        }
        if (method != HttpMethod.POST && method != HttpMethod.PATCH && method != HttpMethod.PUT) {
            payload = null;
        }
        this.makeRequest(options, payload, callback);
    }

    private void makeRequest(RequestOptions options, Buffer payload, Handler<AsyncResult<OAuth2Response>> callback) {
        this.client.request(options, request -> {
            if (request.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)request.cause()));
                return;
            }
            HttpClientRequest req = (HttpClientRequest)request.result();
            Handler resultHandler = send -> {
                if (send.failed()) {
                    callback.handle((Object)Future.failedFuture((Throwable)send.cause()));
                    return;
                }
                HttpClientResponse res = (HttpClientResponse)send.result();
                res.body(body -> {
                    if (body.succeeded()) {
                        OAuth2Response oauth2res = new OAuth2Response(res.statusCode(), res.headers(), (Buffer)body.result());
                        if (res.statusCode() < 200 || res.statusCode() >= 300) {
                            if (oauth2res.body() == null || oauth2res.body().length() == 0) {
                                callback.handle((Object)Future.failedFuture((String)res.statusMessage()));
                            } else {
                                if (oauth2res.is("application/json")) {
                                    try {
                                        JsonObject error = oauth2res.jsonObject();
                                        if (error.containsKey("error")) {
                                            if (error.containsKey("error_description")) {
                                                callback.handle((Object)Future.failedFuture((String)(error.getString("error") + ": " + error.getString("error_description"))));
                                            } else {
                                                callback.handle((Object)Future.failedFuture((String)error.getString("error")));
                                            }
                                            return;
                                        }
                                    }
                                    catch (RuntimeException runtimeException) {
                                        // empty catch block
                                    }
                                }
                                callback.handle((Object)Future.failedFuture((String)(res.statusMessage() + ": " + oauth2res.body())));
                            }
                        } else {
                            callback.handle((Object)Future.succeededFuture((Object)oauth2res));
                        }
                    } else {
                        callback.handle((Object)Future.failedFuture((Throwable)body.cause()));
                    }
                });
            };
            if (payload != null) {
                req.send(payload, resultHandler);
            } else {
                req.send(resultHandler);
            }
        });
    }

    public static void processNonStandardHeaders(JsonObject json, OAuth2Response reply, String sep) {
        String xOAuthScopes = reply.getHeader("X-OAuth-Scopes");
        String xAcceptedOAuthScopes = reply.getHeader("X-Accepted-OAuth-Scopes");
        if (xOAuthScopes != null) {
            LOG.trace((Object)("Received non-standard X-OAuth-Scopes: " + xOAuthScopes));
            if (json.containsKey("scope")) {
                json.put("scope", (Object)(json.getString("scope") + sep + xOAuthScopes));
            } else {
                json.put("scope", (Object)xOAuthScopes);
            }
        }
        if (xAcceptedOAuthScopes != null) {
            LOG.trace((Object)("Received non-standard X-Accepted-OAuth-Scopes: " + xAcceptedOAuthScopes));
            json.put("acceptedScopes", (Object)xAcceptedOAuthScopes);
        }
    }
}

