/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DataObject
public class OAuth2AuthorizationURL {
    private List<String> scopes;
    private String state;
    private Map<String, String> additionalParameters;

    public OAuth2AuthorizationURL() {
    }

    public OAuth2AuthorizationURL(JsonObject json) {
        JsonObject additionalParameters;
        this.setState(json.getString("state"));
        JsonArray scopes = json.getJsonArray("scopes");
        if (scopes != null) {
            scopes.forEach(scope -> this.addScope((String)scope));
        }
        if ((additionalParameters = json.getJsonObject("additionalParameters")) != null) {
            additionalParameters.forEach(entry -> this.putAdditionalParameter((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    public OAuth2AuthorizationURL(OAuth2AuthorizationURL other) {
        this.state = other.state;
        if (other.scopes != null) {
            this.scopes = new ArrayList<String>(other.scopes);
        }
        if (other.additionalParameters != null) {
            this.additionalParameters = new HashMap<String, String>(other.additionalParameters);
        }
    }

    public String getRedirectUri() {
        return this.additionalParameters == null ? null : this.getAdditionalParameters().get("redirect_uri");
    }

    public OAuth2AuthorizationURL setRedirectUri(String redirectUri) {
        this.putAdditionalParameter("redirect_uri", "".equals(redirectUri) ? null : redirectUri);
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public OAuth2AuthorizationURL setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuth2AuthorizationURL addScope(String scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scope);
        return this;
    }

    public String getState() {
        return this.state;
    }

    public OAuth2AuthorizationURL setState(String state) {
        this.state = state;
        return this;
    }

    public String getCodeChallenge() {
        return this.additionalParameters == null ? null : this.getAdditionalParameters().get("code_challenge");
    }

    public OAuth2AuthorizationURL setCodeChallenge(String codeChallenge) {
        this.putAdditionalParameter("code_challenge", codeChallenge);
        return this;
    }

    public String getCodeChallengeMethod() {
        return this.additionalParameters == null ? null : this.getAdditionalParameters().get("code_challenge_method");
    }

    public OAuth2AuthorizationURL setCodeChallengeMethod(String codeChallengeMethod) {
        this.putAdditionalParameter("code_challenge_method", codeChallengeMethod);
        return this;
    }

    public String getPrompt() {
        return this.additionalParameters == null ? null : this.getAdditionalParameters().get("prompt");
    }

    public OAuth2AuthorizationURL setPrompt(String prompt) {
        this.putAdditionalParameter("prompt", prompt);
        return this;
    }

    public String getLoginHint() {
        return this.additionalParameters == null ? null : this.getAdditionalParameters().get("login_hint");
    }

    public OAuth2AuthorizationURL setLoginHint(String loginHint) {
        this.putAdditionalParameter("login_hint", loginHint);
        return this;
    }

    public Map<String, String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public OAuth2AuthorizationURL setAdditionalParameters(Map<String, String> additionalParameters) {
        this.additionalParameters = additionalParameters;
        return this;
    }

    public OAuth2AuthorizationURL putAdditionalParameter(String key, String value) {
        if (value == null) {
            if (this.additionalParameters != null) {
                this.additionalParameters.remove(key);
            }
            return this;
        }
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap<String, String>();
        }
        this.additionalParameters.put(key, value);
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.state != null) {
            json.put("state", (Object)this.state);
        }
        if (this.scopes != null) {
            json.put("scopes", (Object)new JsonArray(this.scopes));
        }
        if (this.additionalParameters != null) {
            json.put("additionalParameters", (Object)new JsonObject(this.additionalParameters));
        }
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

