/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;

@VertxGen
public interface AmazonCognitoAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, String region, String clientId, String clientSecret, String domain, String guid) {
        return AmazonCognitoAuth.create(vertx, region, clientId, clientSecret, domain, guid, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String region, String clientId, String clientSecret, String domain, String userPoolId, HttpClientOptions httpClientOptions) {
        if (region == null) {
            throw new IllegalStateException("region cannot be null");
        }
        String siteBase = String.format("https://cognito-idp.%s.amazonaws.com", region);
        String domainUrl = String.format("https://%s.auth.%s.amazoncognito.com", domain, region);
        return OAuth2Auth.create(vertx, new OAuth2Options().setHttpClientOptions(httpClientOptions).setClientId(clientId).setClientSecret(clientSecret).setTenant(userPoolId).setSite(siteBase + "/{tenant}").setTokenPath(domainUrl + "/oauth2/token").setAuthorizationPath(domainUrl + "/oauth2/authorize").setUserInfoPath(domainUrl + "/oauth2/userInfo").setRevocationPath(domainUrl + "/oauth/revoke").setJwkPath(siteBase + "/{tenant}/.well-known/jwks.json").setLogoutPath(domainUrl + "/logout").setScopeSeparator(" ").setJWTOptions(new JWTOptions().setIssuer(siteBase + "/{tenant}")));
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2Options config) {
        return OpenIDConnectAuth.discover(vertx, new OAuth2Options(config).setScopeSeparator("+"));
    }
}

