/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.impl.http.SimpleHttpClient;
import io.vertx.ext.auth.impl.http.SimpleHttpResponse;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURL;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuth2API {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2API.class);
    private static final Pattern MAX_AGE = Pattern.compile("max-age=\"?(\\d+)\"?");
    private final HttpClient client;
    private final OAuth2Options config;

    public OAuth2API(Vertx vertx, OAuth2Options config) {
        this.config = config;
        this.client = vertx.createHttpClient(config.getHttpClientOptions());
    }

    public Future<JsonObject> jwkSet() {
        JsonObject headers = new JsonObject();
        headers.put("Accept", (Object)"application/jwk-set+json, application/json");
        return this.fetch(HttpMethod.GET, this.config.getJwkPath(), headers, null).compose(reply -> {
            JsonObject json;
            if (reply.body() == null || reply.body().length() == 0) {
                return Future.failedFuture((String)"No Body");
            }
            if (reply.is("application/jwk-set+json") || reply.is("application/json")) {
                try {
                    json = new JsonObject(reply.body());
                }
                catch (RuntimeException e) {
                    return Future.failedFuture((Throwable)e);
                }
            } else {
                return Future.failedFuture((String)("Cannot handle content type: " + reply.headers().get("Content-Type")));
            }
            try {
                if (json.containsKey("error")) {
                    return Future.failedFuture((String)this.extractErrorDescription(json));
                }
                List cacheControl = reply.headers().getAll(HttpHeaders.CACHE_CONTROL);
                if (cacheControl != null) {
                    for (String header : cacheControl) {
                        Matcher match;
                        if (header.length() <= 8 || !(match = MAX_AGE.matcher(header)).find()) continue;
                        try {
                            json.put("maxAge", (Object)Long.valueOf(match.group(1)));
                            break;
                        }
                        catch (RuntimeException runtimeException) {
                        }
                    }
                }
                return Future.succeededFuture((Object)json);
            }
            catch (RuntimeException e) {
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    public String authorizeURL(OAuth2AuthorizationURL params) {
        JsonObject query = new JsonObject();
        if (params.getAdditionalParameters() != null) {
            params.getAdditionalParameters().forEach((arg_0, arg_1) -> ((JsonObject)query).put(arg_0, arg_1));
        }
        query.put("state", (Object)params.getState());
        if (params.getScopes() != null) {
            query.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), params.getScopes()));
        }
        query.put("response_type", (Object)"code");
        String clientId = this.config.getClientId();
        if (clientId != null) {
            query.put("client_id", (Object)clientId);
        } else {
            if (this.config.getClientAssertionType() != null) {
                query.put("client_assertion_type", (Object)this.config.getClientAssertionType());
            }
            if (this.config.getClientAssertion() != null) {
                query.put("client_assertion", (Object)this.config.getClientAssertion());
            }
        }
        String path = this.config.getAuthorizationPath();
        String url = path.charAt(0) == '/' ? this.config.getSite() + path : path;
        return url + "?" + String.valueOf(SimpleHttpClient.jsonToQuery((JsonObject)query));
    }

    public Future<JsonObject> token(String grantType, JsonObject params) {
        String clientId;
        if (grantType == null) {
            return Future.failedFuture((String)"Token request requires a grantType other than null");
        }
        JsonObject headers = new JsonObject();
        JsonObject form = params.copy();
        if (this.config.getExtraParameters() != null) {
            form.mergeIn(this.config.getExtraParameters());
        }
        form.put("grant_type", (Object)grantType);
        if (!this.clientAuthentication(headers, form) && (clientId = this.config.getClientId()) == null) {
            if (this.config.getClientAssertionType() != null) {
                form.put("client_assertion_type", (Object)this.config.getClientAssertionType());
            }
            if (this.config.getClientAssertion() != null) {
                form.put("client_assertion", (Object)this.config.getClientAssertion());
            }
        }
        headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        Buffer payload = SimpleHttpClient.jsonToQuery((JsonObject)form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        return this.fetch(HttpMethod.POST, this.config.getTokenPath(), headers, payload).compose(reply -> {
            JsonObject json;
            if (reply.body() == null || reply.body().length() == 0) {
                return Future.failedFuture((String)"No Body");
            }
            if (reply.is("application/json")) {
                try {
                    json = reply.jsonObject();
                }
                catch (RuntimeException e) {
                    return Future.failedFuture((Throwable)e);
                }
            } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                try {
                    json = SimpleHttpClient.queryToJson((Buffer)reply.body());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    return Future.failedFuture((Throwable)e);
                }
            } else {
                return Future.failedFuture((String)("Cannot handle content type: " + reply.headers().get("Content-Type")));
            }
            try {
                if (json == null || json.containsKey("error")) {
                    return Future.failedFuture((String)this.extractErrorDescription(json));
                }
                OAuth2API.processNonStandardHeaders(json, reply, this.config.getScopeSeparator());
                return Future.succeededFuture((Object)json);
            }
            catch (RuntimeException e) {
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    public Future<JsonObject> tokenIntrospection(String tokenType, String token) {
        JsonObject headers = new JsonObject().put("Content-Type", (Object)"application/x-www-form-urlencoded");
        JsonObject form = new JsonObject().put("token", (Object)token).put("token_type_hint", (Object)tokenType);
        this.clientAuthentication(headers, form);
        Buffer payload = SimpleHttpClient.jsonToQuery((JsonObject)form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        return this.fetch(HttpMethod.POST, this.config.getIntrospectionPath(), headers, payload).compose(reply -> {
            JsonObject json;
            if (reply.body() == null || reply.body().length() == 0) {
                return Future.failedFuture((String)"No Body");
            }
            if (reply.is("application/json")) {
                try {
                    json = reply.jsonObject();
                }
                catch (RuntimeException e) {
                    return Future.failedFuture((Throwable)e);
                }
            } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                try {
                    json = SimpleHttpClient.queryToJson((Buffer)reply.body());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    return Future.failedFuture((Throwable)e);
                }
            } else {
                return Future.failedFuture((String)("Cannot handle accessToken type: " + reply.headers().get("Content-Type")));
            }
            try {
                if (json == null || json.containsKey("error")) {
                    return Future.failedFuture((String)this.extractErrorDescription(json));
                }
                OAuth2API.processNonStandardHeaders(json, reply, this.config.getScopeSeparator());
                return Future.succeededFuture((Object)json);
            }
            catch (RuntimeException e) {
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    public Future<Void> tokenRevocation(String tokenType, String token) {
        if (token == null) {
            return Future.failedFuture((String)"Cannot revoke null token");
        }
        JsonObject headers = new JsonObject().put("Content-Type", (Object)"application/x-www-form-urlencoded");
        JsonObject form = new JsonObject().put("token", (Object)token).put("token_type_hint", (Object)tokenType);
        this.clientAuthentication(headers, form);
        Buffer payload = SimpleHttpClient.jsonToQuery((JsonObject)form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        return this.fetch(HttpMethod.POST, this.config.getRevocationPath(), headers, payload).compose(reply -> {
            if (reply.body() == null) {
                return Future.failedFuture((String)"No Body");
            }
            return Future.succeededFuture();
        });
    }

    public Future<JsonObject> userInfo(String accessToken, JWT jwt) {
        JsonObject headers = new JsonObject();
        JsonObject extraParams = this.config.getUserInfoParameters();
        Object path = this.config.getUserInfoPath();
        if (path == null) {
            return Future.failedFuture((String)"userInfo path is not configured");
        }
        if (extraParams != null) {
            path = (String)path + "?" + String.valueOf(SimpleHttpClient.jsonToQuery((JsonObject)extraParams));
        }
        headers.put("Authorization", (Object)("Bearer " + accessToken));
        headers.put("Accept", (Object)"application/json,application/jwt,application/x-www-form-urlencoded;q=0.9");
        return this.fetch(HttpMethod.GET, (String)path, headers, null).compose(reply -> {
            JsonObject userInfo;
            Buffer body = reply.body();
            if (body == null) {
                return Future.failedFuture((String)"No Body");
            }
            if (reply.is("application/json")) {
                try {
                    userInfo = reply.jsonObject();
                }
                catch (RuntimeException e) {
                    return Future.failedFuture((Throwable)e);
                }
            } else if (reply.is("application/jwt")) {
                try {
                    userInfo = jwt.decode(body.toString(StandardCharsets.UTF_8));
                }
                catch (RuntimeException | SignatureException e) {
                    return Future.failedFuture((Throwable)e);
                }
            } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                try {
                    userInfo = SimpleHttpClient.queryToJson((Buffer)reply.body());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    return Future.failedFuture((Throwable)e);
                }
            } else {
                return Future.failedFuture((String)("Cannot handle Content-Type: " + reply.headers().get("Content-Type")));
            }
            OAuth2API.processNonStandardHeaders(userInfo, reply, this.config.getScopeSeparator());
            return Future.succeededFuture((Object)userInfo);
        });
    }

    public @Nullable String endSessionURL(String idToken, JsonObject params) {
        String path = this.config.getLogoutPath();
        if (path == null) {
            return null;
        }
        JsonObject query = params.copy();
        if (idToken != null) {
            query.put("id_token_hint", (Object)idToken);
        }
        String url = path.charAt(0) == '/' ? this.config.getSite() + path : path;
        return url + "?" + String.valueOf(SimpleHttpClient.jsonToQuery((JsonObject)query));
    }

    private boolean clientAuthentication(JsonObject headers, JsonObject form) {
        boolean confidentialClient;
        boolean bl = confidentialClient = this.config.getClientId() != null && this.config.getClientSecret() != null;
        if (confidentialClient) {
            if (this.config.isUseBasicAuthorization()) {
                String basic = this.config.getClientId() + ":" + this.config.getClientSecret();
                headers.put("Authorization", (Object)("Basic " + Codec.base64Encode((byte[])basic.getBytes(StandardCharsets.UTF_8))));
            } else {
                form.put("client_id", (Object)this.config.getClientId());
                form.put("client_secret", (Object)this.config.getClientSecret());
            }
        } else if (this.config.getClientId() != null) {
            form.put("client_id", (Object)this.config.getClientId());
        }
        return confidentialClient;
    }

    private String extractErrorDescription(JsonObject json) {
        String description;
        if (json == null) {
            return "null";
        }
        Object error = json.getValue("error");
        if (error instanceof JsonObject) {
            description = ((JsonObject)error).getString("message");
        } else {
            try {
                description = json.getString("error_description", json.getString("error"));
            }
            catch (RuntimeException e) {
                description = error.toString();
            }
        }
        if (description == null) {
            return "null";
        }
        return description;
    }

    public Future<SimpleHttpResponse> fetch(HttpMethod method, String path, JsonObject headers, Buffer payload) {
        if (path == null || path.length() == 0) {
            return Future.failedFuture((String)"Invalid path");
        }
        String url = path.charAt(0) == '/' ? this.config.getSite() + path : path;
        LOG.debug((Object)("Fetching URL: " + url));
        RequestOptions options = new RequestOptions().setMethod(method).setAbsoluteURI(url);
        JsonObject tmp = this.config.getHeaders();
        if (tmp != null) {
            for (Map.Entry kv : tmp) {
                options.addHeader((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry kv : headers) {
                options.addHeader((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (this.config.getUserAgent() != null) {
            options.addHeader("User-Agent", this.config.getUserAgent());
        }
        if (method != HttpMethod.POST && method != HttpMethod.PATCH && method != HttpMethod.PUT) {
            payload = null;
        }
        return this.makeRequest(options, payload);
    }

    private Future<SimpleHttpResponse> makeRequest(RequestOptions options, Buffer payload) {
        return this.client.request(options).compose(req -> {
            Function<HttpClientResponse, Future> resultHandler = res -> res.body().compose(body -> {
                SimpleHttpResponse oauth2res = new SimpleHttpResponse(res.statusCode(), res.headers(), body);
                if (res.statusCode() < 200 || res.statusCode() >= 300) {
                    if (oauth2res.body() == null || oauth2res.body().length() == 0) {
                        return Future.failedFuture((String)res.statusMessage());
                    }
                    if (oauth2res.is("application/json")) {
                        try {
                            JsonObject error = oauth2res.jsonObject();
                            if (error != null && error.containsKey("error")) {
                                if (error.containsKey("error_description")) {
                                    return Future.failedFuture((String)(error.getString("error") + ": " + error.getString("error_description")));
                                }
                                return Future.failedFuture((String)error.getString("error"));
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    return Future.failedFuture((String)(res.statusMessage() + ": " + String.valueOf(oauth2res.body())));
                }
                return Future.succeededFuture((Object)oauth2res);
            });
            if (payload != null) {
                return req.send(payload).compose(resultHandler);
            }
            return req.send().compose(resultHandler);
        });
    }

    public static void processNonStandardHeaders(JsonObject json, SimpleHttpResponse reply, String sep) {
        String xOAuthScopes = reply.getHeader("X-OAuth-Scopes");
        String xAcceptedOAuthScopes = reply.getHeader("X-Accepted-OAuth-Scopes");
        if (xOAuthScopes != null) {
            LOG.trace((Object)("Received non-standard X-OAuth-Scopes: " + xOAuthScopes));
            if (json.containsKey("scope")) {
                json.put("scope", (Object)(json.getString("scope") + sep + xOAuthScopes));
            } else {
                json.put("scope", (Object)xOAuthScopes);
            }
        }
        if (xAcceptedOAuthScopes != null) {
            LOG.trace((Object)("Received non-standard X-Accepted-OAuth-Scopes: " + xAcceptedOAuthScopes));
            json.put("acceptedScopes", (Object)xAcceptedOAuthScopes);
        }
    }
}

