/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.shiro.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.shiro.impl.ShiroAuthProviderImpl;
import java.nio.charset.StandardCharsets;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.subject.support.DefaultSubjectContext;

public class ShiroUser
extends AbstractUser {
    private Vertx vertx;
    private SecurityManager securityManager;
    private String username;
    private Subject subject;
    private JsonObject principal;
    private String rolePrefix;

    public ShiroUser(Vertx vertx, SecurityManager securityManager, Subject subject, String rolePrefix) {
        this.vertx = vertx;
        this.securityManager = securityManager;
        this.rolePrefix = rolePrefix;
        this.subject = subject;
        this.username = subject.getPrincipal().toString();
    }

    public ShiroUser() {
    }

    protected void doIsPermitted(String permissionOrRole, Handler<AsyncResult<Boolean>> resultHandler) {
        if (permissionOrRole.startsWith(this.rolePrefix)) {
            this.vertx.executeBlocking(fut -> {
                String role = permissionOrRole.substring(this.rolePrefix.length());
                SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
                fut.complete((Object)this.subject.hasRole(role));
            }, resultHandler);
        } else {
            this.vertx.executeBlocking(fut -> {
                SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
                fut.complete((Object)this.subject.isPermitted(permissionOrRole));
            }, resultHandler);
        }
    }

    public JsonObject principal() {
        if (this.principal == null) {
            this.principal = new JsonObject().put("username", this.username);
        }
        return this.principal;
    }

    public void writeToBuffer(Buffer buff) {
        super.writeToBuffer(buff);
        byte[] bytes = this.username.getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length).appendBytes(bytes);
        bytes = this.rolePrefix.getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length);
        buff.appendBytes(bytes);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        pos = super.readFromBuffer(pos, buffer);
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.username = new String(bytes, StandardCharsets.UTF_8);
        pos += len;
        len = buffer.getInt(pos);
        bytes = buffer.getBytes(pos += 4, pos + len);
        this.rolePrefix = new String(bytes, StandardCharsets.UTF_8);
        return pos += len;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        if (!(authProvider instanceof ShiroAuthProviderImpl)) {
            throw new IllegalArgumentException("Not a ShiroAuthProviderImpl");
        }
        ShiroAuthProviderImpl shiroAuthProvider = (ShiroAuthProviderImpl)authProvider;
        this.vertx = shiroAuthProvider.getVertx();
        this.securityManager = shiroAuthProvider.getSecurityManager();
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
        DefaultSubjectContext subjectContext = new DefaultSubjectContext();
        SimplePrincipalCollection coll = new SimplePrincipalCollection((Object)this.username, shiroAuthProvider.getRealmName());
        subjectContext.setPrincipals((PrincipalCollection)coll);
        this.subject = this.securityManager.createSubject((SubjectContext)subjectContext);
    }
}

