/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.metadata;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public class MetaDataEntry
implements Shareable {
    private static final Base64.Decoder BASE64DEC = Base64.getDecoder();
    private static final List<String> INVALID_STATUS = Arrays.asList("USER_VERIFICATION_BYPASS", "ATTESTATION_KEY_COMPROMISE", "USER_KEY_REMOTE_COMPROMISE", "USER_KEY_PHYSICAL_COMPROMISE", "REVOKED");
    private final JsonObject entry;
    private final JsonObject statement;
    private final String error;

    public MetaDataEntry(JsonObject statement) {
        if (statement == null) {
            throw new IllegalArgumentException("MetaData statement cannot be null");
        }
        this.entry = null;
        this.statement = statement;
        this.error = null;
    }

    public MetaDataEntry(JsonObject tocEntry, byte[] rawStatement, String error) throws NoSuchAlgorithmException {
        MessageDigest sha256;
        byte[] digest;
        if (tocEntry == null || rawStatement == null) {
            throw new IllegalArgumentException("toc and statement cannot be null");
        }
        this.entry = tocEntry;
        this.statement = new JsonObject(Buffer.buffer((byte[])BASE64DEC.decode(rawStatement)));
        for (Object o : this.entry.getJsonArray("statusReports")) {
            JsonObject statusReport = (JsonObject)o;
            statusReport.put("effectiveDate", (Object)LocalDate.parse(statusReport.getString("effectiveDate"), DateTimeFormatter.ISO_DATE).atStartOfDay().toInstant(ZoneOffset.UTC));
        }
        this.error = error != null ? error : (MessageDigest.isEqual(digest = (sha256 = MessageDigest.getInstance("SHA-256")).digest(rawStatement), this.entry.getBinary("hash")) ? null : "MDS entry hash did not match corresponding hash in MDS TOC");
    }

    void checkValid() throws MetaDataException {
        if (this.error != null) {
            throw new MetaDataException(this.error);
        }
        if (this.entry != null) {
            Instant now = Instant.now();
            JsonArray reports = this.entry.getJsonArray("statusReports");
            for (int i = reports.size() - 1; i >= 0; --i) {
                JsonObject statusReport = reports.getJsonObject(i);
                if (!statusReport.getInstant("effectiveDate").isBefore(now)) continue;
                if (INVALID_STATUS.contains(statusReport.getString("status"))) {
                    throw new MetaDataException("Invalid MDS status: " + statusReport.getString("status"));
                }
                return;
            }
            throw new MetaDataException("Invalid MDS statusReports");
        }
    }

    JsonObject statement() {
        return this.statement;
    }
}

