/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.webauthn.Attestation;
import io.vertx.ext.auth.webauthn.AuthenticatorAttachment;
import io.vertx.ext.auth.webauthn.AuthenticatorTransport;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.RelyingParty;
import io.vertx.ext.auth.webauthn.UserVerification;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class WebAuthnOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, WebAuthnOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "attestation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAttestation(Attestation.valueOf((String)member.getValue()));
                    break;
                }
                case "authenticatorAttachment": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAuthenticatorAttachment(AuthenticatorAttachment.valueOf((String)member.getValue()));
                    break;
                }
                case "challengeLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setChallengeLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "extensions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setExtensions(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "pubKeyCredParams": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<PublicKeyCredential> list = new ArrayList<PublicKeyCredential>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(PublicKeyCredential.valueOf((String)item));
                        }
                    });
                    obj.setPubKeyCredParams(list);
                    break;
                }
                case "relyingParty": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setRelyingParty(new RelyingParty((JsonObject)member.getValue()));
                    break;
                }
                case "requireResidentKey": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRequireResidentKey((Boolean)member.getValue());
                    break;
                }
                case "rootCertificates": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setRootCertificates(map);
                    break;
                }
                case "rootCrls": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<PublicKeyCredential> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((PublicKeyCredential)((Object)((String)item)));
                        }
                    });
                    obj.setRootCrls(list);
                    break;
                }
                case "timeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "transports": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<PublicKeyCredential> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((PublicKeyCredential)((Object)AuthenticatorTransport.valueOf((String)item)));
                        }
                    });
                    obj.setTransports(list);
                    break;
                }
                case "userVerification": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUserVerification(UserVerification.valueOf((String)member.getValue()));
                }
            }
        }
    }

    public static void toJson(WebAuthnOptions obj, JsonObject json) {
        WebAuthnOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(WebAuthnOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getAttestation() != null) {
            json.put("attestation", obj.getAttestation().name());
        }
        if (obj.getAuthenticatorAttachment() != null) {
            json.put("authenticatorAttachment", obj.getAuthenticatorAttachment().name());
        }
        json.put("challengeLength", obj.getChallengeLength());
        if (obj.getExtensions() != null) {
            json.put("extensions", obj.getExtensions());
        }
        if (obj.getPubKeyCredParams() != null) {
            array = new JsonArray();
            obj.getPubKeyCredParams().forEach(item -> array.add((Object)item.name()));
            json.put("pubKeyCredParams", array);
        }
        if (obj.getRelyingParty() != null) {
            json.put("relyingParty", obj.getRelyingParty().toJson());
        }
        json.put("requireResidentKey", obj.getRequireResidentKey());
        if (obj.getTimeout() != null) {
            json.put("timeout", obj.getTimeout());
        }
        if (obj.getTransports() != null) {
            array = new JsonArray();
            obj.getTransports().forEach(item -> array.add((Object)item.name()));
            json.put("transports", array);
        }
        if (obj.getUserVerification() != null) {
            json.put("userVerification", obj.getUserVerification().name());
        }
    }
}

