/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CBOR {
    private static final Base64.Encoder B64ENC = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder B64DEC = Base64.getUrlDecoder();
    private static final CBORFactory FACTORY = new CBORFactory();

    public static JsonParser cborParser(String base64) {
        return CBOR.cborParser(B64DEC.decode(base64));
    }

    public static JsonParser cborParser(byte[] data) {
        try {
            return FACTORY.createParser(data);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
    }

    public static JsonParser cborParser(Buffer buf) {
        try {
            return FACTORY.createParser((InputStream)new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T parse(JsonParser parser) throws DecodeException {
        try {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            return (T)CBOR.parseAny(parser);
        }
        catch (IOException e) {
            throw new DecodeException(e.getMessage(), (Throwable)e);
        }
    }

    private static Object parseAny(JsonParser parser) throws IOException, DecodeException {
        switch (parser.getCurrentTokenId()) {
            case 1: {
                return CBOR.parseObject(parser);
            }
            case 3: {
                return CBOR.parseArray(parser);
            }
            case 12: {
                return B64ENC.encodeToString(parser.getBinaryValue(Base64Variants.MODIFIED_FOR_URL));
            }
            case 6: {
                return parser.getText();
            }
            case 7: 
            case 8: {
                return parser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        throw new DecodeException("Unexpected token");
    }

    private static Map<String, Object> parseObject(JsonParser parser) throws IOException {
        String key1 = parser.nextFieldName();
        if (key1 == null) {
            return new LinkedHashMap<String, Object>(2);
        }
        parser.nextToken();
        Object value1 = CBOR.parseAny(parser);
        String key2 = parser.nextFieldName();
        if (key2 == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            return obj;
        }
        parser.nextToken();
        Object value2 = CBOR.parseAny(parser);
        String key = parser.nextFieldName();
        if (key == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            obj.put(key2, value2);
            return obj;
        }
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put(key1, value1);
        obj.put(key2, value2);
        do {
            parser.nextToken();
            Object value = CBOR.parseAny(parser);
            obj.put(key, value);
        } while ((key = parser.nextFieldName()) != null);
        return obj;
    }

    private static List<Object> parseArray(JsonParser parser) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        while (true) {
            parser.nextToken();
            int tokenId = parser.getCurrentTokenId();
            if (tokenId == 5) {
                throw new UnsupportedOperationException();
            }
            if (tokenId == 4) {
                return array;
            }
            Object value = CBOR.parseAny(parser);
            array.add(value);
        }
    }
}

