/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.ASN1;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaData;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public class AppleAttestation
implements Attestation {
    @Override
    public String fmt() {
        return "apple";
    }

    @Override
    public void validate(WebAuthnOptions options, MetaData metadata, byte[] clientDataJSON, JsonObject attestation, AuthData authData) throws AttestationException {
        try {
            byte[] clientDataHash = Attestation.hash("SHA-256", clientDataJSON);
            JsonObject attStmt = attestation.getJsonObject("attStmt");
            if (!attStmt.containsKey("x5c")) {
                throw new AttestationException("No attestation x5c");
            }
            List<X509Certificate> certChain = Attestation.parseX5c(attStmt.getJsonArray("x5c"));
            if (certChain.size() == 0) {
                throw new AttestationException("no certificates in x5c field");
            }
            certChain.add(options.getRootCertificate(this.fmt()));
            CertificateHelper.checkValidity(certChain, (boolean)true, options.getRootCrls());
            byte[] nonceToHash = Buffer.buffer().appendBytes(authData.getRaw()).appendBytes(clientDataHash).getBytes();
            byte[] nonce = Attestation.hash("SHA-256", nonceToHash);
            X509Certificate credCert = certChain.get(0);
            byte[] appleExtension = credCert.getExtensionValue("1.2.840.113635.100.8.2");
            ASN1.ASN extension = ASN1.parseASN1(appleExtension);
            if (extension.tag.type != 4) {
                throw new AttestationException("1.2.840.113635.100.8.2 Extension is not an ASN.1 OCTET string!");
            }
            extension = ASN1.parseASN1(extension.binary(0));
            if (extension.tag.type != 48) {
                throw new AttestationException("1.2.840.113635.100.8.2 Extension is not an ASN.1 SEQUENCE!");
            }
            if (!MessageDigest.isEqual(nonce, extension.object(0).object(0).binary(0))) {
                throw new AttestationException("Certificate 1.2.840.113635.100.8.2 extension does not match nonce");
            }
            if (!credCert.getPublicKey().equals(authData.getCredentialJWK().getPublicKey())) {
                throw new AttestationException("credCert public key does not equal authData public key");
            }
            PublicKeyCredential alg = attStmt.containsKey("alg") ? PublicKeyCredential.valueOf(attStmt.getInteger("alg")) : null;
            metadata.verifyMetadata(authData.getAaguidString(), alg, certChain);
        }
        catch (MetaDataException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new AttestationException(e);
        }
    }
}

