/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.jose.JWS;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaData;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public interface Attestation {
    public String fmt();

    public void validate(WebAuthnOptions var1, MetaData var2, byte[] var3, JsonObject var4, AuthData var5) throws AttestationException;

    public static byte[] hash(String algorithm, byte[] data) throws AttestationException, NoSuchAlgorithmException {
        if (algorithm == null || data == null) {
            throw new AttestationException("Cannot hash one of {algorithm, data} is null");
        }
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(data);
        return md.digest();
    }

    public static void verifySignature(PublicKeyCredential publicKeyCredential, X509Certificate certificate, byte[] signature, byte[] data) throws AttestationException, InvalidKeyException, SignatureException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (!JWS.verifySignature((String)publicKeyCredential.name(), (X509Certificate)certificate, (byte[])signature, (byte[])data)) {
            throw new AttestationException("Failed to verify signature");
        }
    }

    public static List<X509Certificate> parseX5c(JsonArray x5c) throws CertificateException {
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        if (x5c == null || x5c.size() == 0) {
            return certChain;
        }
        for (int i = 0; i < x5c.size(); ++i) {
            certChain.add(JWS.parseX5c((byte[])x5c.getBinary(i)));
        }
        return certChain;
    }
}

