/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaData;

public class NoneAttestation
implements Attestation {
    @Override
    public String fmt() {
        return "none";
    }

    @Override
    public void validate(WebAuthnOptions options, MetaData metadata, byte[] clientDataJSON, JsonObject attestation, AuthData authData) throws AttestationException {
        if (!"00000000-0000-0000-0000-000000000000".equals(authData.getAaguidString())) {
            throw new AttestationException("AAGUID is not 00000000-0000-0000-0000-000000000000!");
        }
        if (attestation.containsKey("attStmt") && attestation.getJsonObject("attStmt").size() > 0) {
            throw new AttestationException("attStmt is present!");
        }
    }
}

