/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl;

import com.fasterxml.jackson.core.JsonParser;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.cose.CWK;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.webauthn.impl.CBOR;
import java.io.IOException;
import java.util.Map;

public class AuthData {
    public static final int USER_PRESENT = 1;
    public static final int USER_VERIFIED = 4;
    public static final int ATTESTATION_DATA = 64;
    public static final int EXTENSION_DATA = 128;
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private final byte[] raw;
    private final byte[] rpIdHash;
    private final byte flags;
    private final long signCounter;
    private byte[] aaguid;
    private String aaguidString = "00000000-0000-0000-0000-000000000000";
    private byte[] credentialId;
    private byte[] credentialPublicKey;
    private JsonObject credentialPublicKeyJson;
    private JWK credentialJWK;
    private byte[] extensions;
    private JsonObject extensionsData;

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX[v >>> 4];
            hexChars[j * 2 + 1] = HEX[v & 0xF];
        }
        return new String(hexChars);
    }

    public AuthData(byte[] data) {
        this.raw = data;
        Buffer buffer = Buffer.buffer((byte[])data);
        if (buffer.length() < 37) {
            throw new IllegalArgumentException("Authenticator Data must be at least 37 bytes long!");
        }
        int pos = 0;
        this.rpIdHash = buffer.getBytes(pos, pos + 32);
        this.flags = buffer.getByte(pos += 32);
        this.signCounter = buffer.getUnsignedInt(++pos);
        pos += 4;
        if ((this.flags & 0x40) != 0) {
            if (buffer.length() < 128) {
                throw new IllegalArgumentException("It seems as the Attestation Data flag is set, but the data is smaller than 128 bytes. You might have set AT flag for the assertion response.");
            }
            this.aaguid = buffer.getBytes(pos, pos + 16);
            String tmp = AuthData.bytesToHex(this.aaguid);
            this.aaguidString = tmp.substring(0, 8) + "-" + tmp.substring(8, 12) + "-" + tmp.substring(12, 16) + "-" + tmp.substring(16, 20) + "-" + tmp.substring(20);
            int credIDLen = buffer.getUnsignedShort(pos += 16);
            this.credentialId = buffer.getBytes(pos += 2, pos + credIDLen);
            byte[] bytes = buffer.getBytes(pos += credIDLen, buffer.length());
            try (JsonParser parser = CBOR.cborParser(bytes);){
                this.credentialPublicKeyJson = new JsonObject((Map)CBOR.parse(parser));
                this.credentialJWK = CWK.toJWK((Iterable)this.credentialPublicKeyJson);
                int credentialPublicKeyLen = (int)parser.getCurrentLocation().getByteOffset();
                this.credentialPublicKey = buffer.getBytes(pos, pos + credentialPublicKeyLen);
                pos += credentialPublicKeyLen;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid CBOR message");
            }
        }
        if ((this.flags & 0x80) != 0) {
            byte[] bytes = buffer.getBytes(pos, buffer.length());
            try (JsonParser parser = CBOR.cborParser(bytes);){
                this.extensionsData = new JsonObject((Map)CBOR.parse(parser));
                int extensionsDataLen = (int)parser.getCurrentLocation().getByteOffset();
                this.extensions = buffer.getBytes(pos, pos + extensionsDataLen);
                pos += extensionsDataLen;
            }
            catch (IOException e) {
                throw new DecodeException("Invalid CBOR message");
            }
        }
        if (buffer.length() > pos) {
            throw new DecodeException("Failed to decode authData! Leftover bytes been detected!");
        }
    }

    public boolean is(int flag) {
        return (this.flags & flag) != 0;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public byte[] getRpIdHash() {
        return this.rpIdHash;
    }

    public byte getFlags() {
        return this.flags;
    }

    public long getSignCounter() {
        return this.signCounter;
    }

    public byte[] getAaguid() {
        return this.aaguid;
    }

    public String getAaguidString() {
        return this.aaguidString;
    }

    public byte[] getCredentialId() {
        return this.credentialId;
    }

    public byte[] getCredentialPublicKey() {
        return this.credentialPublicKey;
    }

    public JsonObject getCredentialPublicKeyJson() {
        return this.credentialPublicKeyJson;
    }

    public JWK getCredentialJWK() {
        return this.credentialJWK;
    }

    public byte[] getExtensions() {
        return this.extensions;
    }

    public JsonObject getExtensionsData() {
        return this.extensionsData;
    }
}

