/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.asn.ASN1;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaData;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;

public class AndroidKeyAttestation
implements Attestation {
    private static final JsonArray EMPTY = new JsonArray(Collections.emptyList());

    @Override
    public String fmt() {
        return "android-key";
    }

    @Override
    public AttestationCertificates validate(WebAuthnOptions options, MetaData metadata, byte[] clientDataJSON, JsonObject attestation, AuthData authData) throws AttestationException {
        try {
            byte[] clientDataHash = Attestation.hash("SHA-256", clientDataJSON);
            byte[] signatureBase = Buffer.buffer().appendBytes(authData.getRaw()).appendBytes(clientDataHash).getBytes();
            JsonObject attStmt = attestation.getJsonObject("attStmt");
            byte[] signature = attStmt.getBinary("sig");
            List<X509Certificate> certChain = Attestation.parseX5c(attStmt.getJsonArray("x5c"));
            if (certChain.size() == 0) {
                throw new AttestationException("Invalid certificate chain");
            }
            X509Certificate leafCert = certChain.get(0);
            Attestation.verifySignature(PublicKeyCredential.valueOf(attStmt.getInteger("alg")), leafCert, signature, signatureBase);
            JsonObject statement = metadata.verifyMetadata(authData.getAaguidString(), PublicKeyCredential.valueOf(attStmt.getInteger("alg")), certChain);
            JWK coseKey = authData.getCredentialJWK();
            if (!leafCert.getPublicKey().equals(coseKey.publicKey())) {
                throw new AttestationException("Certificate public key does not match public key in authData!");
            }
            ASN1.ASN attestationExtension = ASN1.parseASN1((Buffer)Buffer.buffer((byte[])leafCert.getExtensionValue("1.3.6.1.4.1.11129.2.1.17")));
            if (attestationExtension.tag.type != 4) {
                throw new AttestationException("Attestation Extension is not an ASN.1 OCTECT string!");
            }
            attestationExtension = ASN1.parseASN1((Buffer)Buffer.buffer((byte[])attestationExtension.binary(0)));
            if (attestationExtension.tag.type != 48) {
                throw new AttestationException("Attestation Extension Value is not an ASN.1 SEQUENCE!");
            }
            byte[] data = attestationExtension.object(4).binary(0);
            if (!MessageDigest.isEqual(clientDataHash, data)) {
                throw new AttestationException("Certificate attestation challenge is not set to the clientData hash!");
            }
            ASN1.ASN softwareEnforcedAuthz = attestationExtension.object(6);
            for (Object object : softwareEnforcedAuthz.value) {
                if (!(object instanceof ASN1.ASN) || ((ASN1.ASN)object).tag.number != 600) continue;
                throw new AttestationException("Software authorisation list contains 'allApplication' flag, which means that credential is not bound to the RP!");
            }
            ASN1.ASN teeEnforcedAuthz = attestationExtension.object(7);
            for (Object object : teeEnforcedAuthz.value) {
                if (!(object instanceof ASN1.ASN) || ((ASN1.ASN)object).tag.number != 600) continue;
                throw new AttestationException("TEE authorisation list contains 'allApplication' flag, which means that credential is not bound to the RP!");
            }
            if (statement == null || statement.getJsonArray("attestationRootCertificates", EMPTY).size() == 0) {
                JsonArray x5c = attStmt.getJsonArray("x5c");
                if (!MessageDigest.isEqual(options.getRootCertificate(this.fmt()).getEncoded(), x5c.getBinary(x5c.size() - 1))) {
                    throw new AttestationException("Root certificate is invalid!");
                }
            }
            return new AttestationCertificates().setAlg(PublicKeyCredential.valueOf(attStmt.getInteger("alg"))).setX5c(attStmt.getJsonArray("x5c"));
        }
        catch (MetaDataException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new AttestationException(e);
        }
    }
}

