/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.asn.ASN1;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWS;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaData;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class PackedAttestation
implements Attestation {
    private final Set<String> ISO3166 = new HashSet<String>();

    public PackedAttestation() {
        this.ISO3166.addAll(Arrays.asList(Locale.getISOCountries()));
    }

    @Override
    public String fmt() {
        return "packed";
    }

    @Override
    public AttestationCertificates validate(WebAuthnOptions options, MetaData metadata, byte[] clientDataJSON, JsonObject attestation, AuthData authData) throws AttestationException {
        try {
            byte[] clientDataHash = Attestation.hash("SHA-256", clientDataJSON);
            JsonObject attStmt = attestation.getJsonObject("attStmt");
            byte[] signature = attStmt.getBinary("sig");
            if (attStmt.containsKey("x5c")) {
                JsonObject statement;
                List<X509Certificate> certChain = Attestation.parseX5c(attStmt.getJsonArray("x5c"));
                if (certChain.size() == 0) {
                    throw new AttestationException("no certificates in x5c field");
                }
                X509Certificate x509Certificate = certChain.get(0);
                CertificateHelper.CertInfo certInfo = CertificateHelper.getCertInfo((X509Certificate)certChain.get(0));
                if (certInfo.version() != 3) {
                    throw new AttestationException("Batch certificate version MUST be 3(ASN1 2)");
                }
                if (!certInfo.subjectHas("C") || !this.ISO3166.contains(certInfo.subject("C"))) {
                    throw new AttestationException("Batch certificate C MUST be set to two character ISO 3166 code");
                }
                if (!certInfo.subjectHas("O")) {
                    throw new AttestationException("Batch certificate CN MUST no be empty");
                }
                if (!"Authenticator Attestation".equals(certInfo.subject("OU"))) {
                    throw new AttestationException("Batch certificate OU MUST be set strictly to 'Authenticator Attestation'");
                }
                if (!certInfo.subjectHas("CN")) {
                    throw new AttestationException("Batch certificate CN MUST no be empty");
                }
                if (certInfo.basicConstraintsCA() != -1) {
                    throw new AttestationException("Batch certificate basic constraints CA MUST be -1");
                }
                byte[] idFidoGenCeAaguid = x509Certificate.getExtensionValue("1.3.6.1.4.1.45724.1.1.4");
                if (idFidoGenCeAaguid != null) {
                    ASN1.ASN extension = ASN1.parseASN1((byte[])idFidoGenCeAaguid);
                    if (extension.tag.type != 4) {
                        throw new AttestationException("1.3.6.1.4.1.45724.1.1.4 Extension is not an ASN.1 OCTECT string!");
                    }
                    extension = ASN1.parseASN1((byte[])extension.binary(0));
                    if (extension.tag.type != 4) {
                        throw new AttestationException("1.3.6.1.4.1.45724.1.1.4 Extension is not an ASN.1 OCTECT string!");
                    }
                    if (!MessageDigest.isEqual(extension.binary(0), authData.getAaguid())) {
                        throw new AttestationException("Certificate id-fido-gen-ce-aaguid extension does not match authData");
                    }
                }
                if ((statement = metadata.verifyMetadata(authData.getAaguidString(), PublicKeyCredential.valueOf(attStmt.getInteger("alg")), certChain)) != null && !statement.getJsonArray("attestationTypes").contains((Object)15879)) {
                    throw new AttestationException("Metadata does not indicate support for full attestations");
                }
                byte[] signatureBase = Buffer.buffer().appendBytes(authData.getRaw()).appendBytes(clientDataHash).getBytes();
                Attestation.verifySignature(PublicKeyCredential.valueOf(attStmt.getInteger("alg")), x509Certificate, signature, signatureBase);
            } else {
                if (attStmt.containsKey("ecdaaKeyId")) {
                    JsonObject statement = metadata.verifyMetadata(authData.getAaguidString(), PublicKeyCredential.valueOf(attStmt.getInteger("alg")), null);
                    if (statement != null && !statement.getJsonArray("attestationTypes").contains((Object)15881)) {
                        throw new AttestationException("Metadata does not indicate support for ecdaa attestations");
                    }
                    throw new AttestationException("ECDAA IS NOT SUPPORTED YET!");
                }
                JsonObject statement = metadata.verifyMetadata(authData.getAaguidString(), PublicKeyCredential.valueOf(attStmt.getInteger("alg")), null);
                if (statement != null && !statement.getJsonArray("attestationTypes").contains((Object)15880)) {
                    throw new AttestationException("Metadata does not indicate support for surrogate attestations");
                }
                byte[] signatureBase = Buffer.buffer().appendBytes(authData.getRaw()).appendBytes(clientDataHash).getBytes();
                JWK key = authData.getCredentialJWK();
                JWS jws = new JWS(key);
                if (!jws.verify(signature, signatureBase)) {
                    throw new AttestationException("Failed to verify the signature!");
                }
            }
            return new AttestationCertificates().setAlg(PublicKeyCredential.valueOf(attStmt.getInteger("alg"))).setX5c(attStmt.containsKey("x5c") ? attStmt.getJsonArray("x5c") : null);
        }
        catch (MetaDataException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new AttestationException(e);
        }
    }
}

