/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.metadata;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.http.SimpleHttpClient;
import io.vertx.ext.auth.impl.http.SimpleHttpResponse;
import io.vertx.ext.auth.impl.jose.JWS;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.ext.auth.webauthn.MetaDataService;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaData;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataEntry;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class MetaDataServiceImpl
implements MetaDataService {
    private static final Base64.Decoder BASE64DEC = Base64.getDecoder();
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataServiceImpl.class);
    private final VertxInternal vertx;
    private final WebAuthnOptions options;
    private final SimpleHttpClient httpClient;
    private final JWT jwt;
    private final MetaData metadata;

    public MetaDataServiceImpl(Vertx vertx, WebAuthnOptions options) {
        this.vertx = (VertxInternal)vertx;
        this.options = options;
        this.httpClient = new SimpleHttpClient(vertx, "vertx-auth", new HttpClientOptions());
        this.jwt = new JWT().allowEmbeddedKey(true);
        this.metadata = new MetaData(vertx, options);
    }

    @Override
    public Future<Boolean> fetchTOC(String toc) {
        PromiseInternal promise = this.vertx.promise();
        this.httpClient.fetch(HttpMethod.GET, toc, null, null).onFailure(arg_0 -> ((Promise)promise).fail(arg_0)).onSuccess(arg_0 -> this.lambda$fetchTOC$3((Promise)promise, arg_0));
        return promise.future();
    }

    private Future<Void> addEntry(String error, JsonObject entry) {
        PromiseInternal promise = this.vertx.promise();
        this.httpClient.fetch(HttpMethod.GET, entry.getString("url"), null, null).onFailure(arg_0 -> ((Promise)promise).fail(arg_0)).onSuccess(arg_0 -> this.lambda$addEntry$4(entry, error, (Promise)promise, arg_0));
        return promise.future();
    }

    @Override
    public MetaDataService addStatement(JsonObject statement) {
        this.metadata.loadMetadata(new MetaDataEntry(statement));
        return this;
    }

    @Override
    public MetaDataService flush() {
        this.metadata.clear();
        return this;
    }

    @Override
    public JsonObject verify(Authenticator authenticator) {
        try {
            boolean includesRoot;
            switch (authenticator.getFmt()) {
                case "none": 
                case "android-safetynet": 
                case "tpm": {
                    includesRoot = false;
                    break;
                }
                default: {
                    includesRoot = true;
                }
            }
            return this.metadata.verifyMetadata(authenticator.getAaguid(), authenticator.getAttestationCertificates().getAlg(), MetaDataServiceImpl.parseX5c(authenticator.getAttestationCertificates().getX5c()), includesRoot);
        }
        catch (AttestationException | MetaDataException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<X509Certificate> parseX5c(List<String> x5c) throws CertificateException {
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        if (x5c == null || x5c.size() == 0) {
            return certChain;
        }
        for (String s : x5c) {
            certChain.add(JWS.parseX5c((byte[])JsonUtil.BASE64_DECODER.decode(s)));
        }
        return certChain;
    }

    public MetaData metadata() {
        return this.metadata;
    }

    private /* synthetic */ void lambda$addEntry$4(JsonObject entry, String error, Promise promise, SimpleHttpResponse res) {
        try {
            this.metadata.loadMetadata(new MetaDataEntry(entry, res.body().getBytes(), error));
            promise.complete();
        }
        catch (RuntimeException | NoSuchAlgorithmException e) {
            promise.fail((Throwable)e);
        }
    }

    private /* synthetic */ void lambda$fetchTOC$3(Promise promise, SimpleHttpResponse res) {
        JsonObject payload;
        String error = null;
        try {
            JsonObject json = this.jwt.decode(res.body().toString(), true);
            JsonArray chain = json.getJsonObject("header").getJsonArray("x5c");
            ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
            for (int i = 0; i < chain.size(); ++i) {
                certChain.add(JWS.parseX5c((byte[])BASE64DEC.decode(chain.getString(i).getBytes(StandardCharsets.UTF_8))));
            }
            certChain.add(this.options.getRootCertificate("mds"));
            CertificateHelper.checkValidity(certChain, this.options.getRootCrls());
            payload = json.getJsonObject("payload");
        }
        catch (RuntimeException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            try {
                error = e.getMessage();
                payload = JWT.parse((String)res.body().toString()).getJsonObject("payload");
            }
            catch (RuntimeException re) {
                promise.fail((Throwable)re);
                return;
            }
        }
        try {
            if (payload == null) {
                promise.fail("Could not parse TOC");
            } else {
                JsonArray entries = payload.getJsonArray("entries");
                String e = error;
                AtomicInteger cnt = new AtomicInteger(entries.size());
                AtomicBoolean success = new AtomicBoolean(true);
                entries.forEach(el -> this.addEntry(e, (JsonObject)el).onFailure(err -> {
                    LOG.error((Object)"Failed to add entry", err);
                    success.set(false);
                    if (cnt.decrementAndGet() == 0) {
                        promise.complete((Object)success.get());
                    }
                }).onComplete(done -> {
                    if (cnt.decrementAndGet() == 0) {
                        promise.complete((Object)success.get());
                    }
                }));
            }
        }
        catch (RuntimeException e) {
            promise.fail((Throwable)e);
        }
    }
}

