/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation;

import com.fasterxml.jackson.core.JsonParser;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.CBOR;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaData;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

public class FidoU2fAttestation
implements Attestation {
    @Override
    public String fmt() {
        return "fido-u2f";
    }

    @Override
    public AttestationCertificates validate(WebAuthnOptions options, MetaData metadata, byte[] clientDataJSON, JsonObject attestation, AuthData authData) throws AttestationException {
        try {
            if (!"00000000-0000-0000-0000-000000000000".equals(authData.getAaguidString())) {
                throw new AttestationException("AAGUID is not 00000000-0000-0000-0000-000000000000!");
            }
            byte[] clientDataHash = Attestation.hash("SHA-256", clientDataJSON);
            byte[] publicKey = FidoU2fAttestation.COSEECDHAtoPKCS(authData.getCredentialPublicKey());
            Buffer signatureBase = Buffer.buffer().appendByte((byte)0).appendBytes(authData.getRpIdHash()).appendBytes(clientDataHash).appendBytes(authData.getCredentialId()).appendBytes(publicKey);
            JsonObject attStmt = attestation.getJsonObject("attStmt");
            List<X509Certificate> certChain = Attestation.parseX5c(attStmt.getJsonArray("x5c"));
            if (certChain.size() == 0) {
                throw new AttestationException("no certificates in x5c field");
            }
            CertificateHelper.checkValidity(certChain, options.getRootCrls());
            Attestation.verifySignature(PublicKeyCredential.ES256, certChain.get(0), Codec.base64UrlDecode((String)attStmt.getString("sig")), signatureBase.getBytes());
            return new AttestationCertificates().setAlg(PublicKeyCredential.ES256).setX5c(attStmt.getJsonArray("x5c"));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new AttestationException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] COSEECDHAtoPKCS(byte[] cosePublicKey) {
        try (JsonParser parser = CBOR.cborParser(cosePublicKey);){
            JsonObject key = new JsonObject((Map)CBOR.parse(parser));
            byte[] byArray = Buffer.buffer().appendByte((byte)4).appendBytes(Codec.base64UrlDecode((String)key.getString("-2"))).appendBytes(Codec.base64UrlDecode((String)key.getString("-3"))).getBytes();
            return byArray;
        }
        catch (IOException e) {
            throw new DecodeException(e.getMessage());
        }
    }
}

