/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.impl.cose.CWK;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWS;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.ext.auth.webauthn.AuthenticatorTransport;
import io.vertx.ext.auth.webauthn.MetaDataService;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthn;
import io.vertx.ext.auth.webauthn.WebAuthnCredentials;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.CBOR;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataServiceImpl;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Function;

public class WebAuthnImpl
implements WebAuthn {
    private static final Logger LOG = LoggerFactory.getLogger(WebAuthn.class);
    private final Map<String, Attestation> attestations = new HashMap<String, Attestation>();
    private final VertxContextPRNG random;
    private final WebAuthnOptions options;
    private final MetaDataServiceImpl mds;
    private Function<Authenticator, Future<List<Authenticator>>> fetcher = authr -> Future.failedFuture((String)"Fetcher function not available");
    private Function<Authenticator, Future<Void>> updater = authr -> Future.failedFuture((String)"Updater function not available");

    public WebAuthnImpl(Vertx vertx, WebAuthnOptions options) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.options = options;
        if (options == null) {
            throw new IllegalArgumentException("options cannot be null!");
        }
        if (options.getRelyingParty() == null) {
            throw new IllegalArgumentException("options.relyingParty cannot be null!");
        }
        if (options.getRelyingParty().getName() == null) {
            throw new IllegalArgumentException("options.relyingParty.name cannot be null!");
        }
        this.mds = new MetaDataServiceImpl(vertx, options);
        ServiceLoader<Attestation> attestationServiceLoader = ServiceLoader.load(Attestation.class);
        for (Attestation att : attestationServiceLoader) {
            this.attestations.put(att.fmt(), att);
        }
    }

    private String randomBase64URLBuffer(int length) {
        byte[] buff = new byte[length];
        this.random.nextBytes(buff);
        return Codec.base64UrlEncode((byte[])buff);
    }

    private void putOpt(JsonObject json, String key, Object value) {
        if (value != null) {
            if (value instanceof Enum) {
                json.put(key, (Object)value.toString());
                return;
            }
            if (value instanceof JsonObject && ((JsonObject)value).isEmpty()) {
                return;
            }
            if (value instanceof JsonArray && ((JsonArray)value).isEmpty()) {
                return;
            }
            json.put(key, value);
        }
    }

    private void addOpt(JsonArray json, Object value) {
        if (value != null) {
            if (value instanceof Enum) {
                json.add((Object)value.toString());
                return;
            }
            if (value instanceof JsonObject && ((JsonObject)value).isEmpty()) {
                return;
            }
            if (value instanceof JsonArray && ((JsonArray)value).isEmpty()) {
                return;
            }
            json.add(value);
        }
    }

    private static String uUIDtoBase64Url(UUID uuid) {
        Buffer buffer = Buffer.buffer((int)16);
        buffer.setLong(0, uuid.getMostSignificantBits());
        buffer.setLong(8, uuid.getLeastSignificantBits());
        return Codec.base64UrlEncode((byte[])buffer.getBytes());
    }

    @Override
    public WebAuthn authenticatorFetcher(Function<Authenticator, Future<List<Authenticator>>> fetcher) {
        if (fetcher == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public WebAuthn authenticatorUpdater(Function<Authenticator, Future<Void>> updater) {
        if (updater == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        this.updater = updater;
        return this;
    }

    @Override
    public Future<JsonObject> createCredentialsOptions(JsonObject user) {
        return this.fetcher.apply(new Authenticator().setUserName(user.getString("name"))).map(authenticators -> {
            JsonObject json = new JsonObject().put("rp", (Object)new JsonObject()).put("user", (Object)new JsonObject()).put("challenge", (Object)this.randomBase64URLBuffer(this.options.getChallengeLength())).put("pubKeyCredParams", (Object)new JsonArray()).put("authenticatorSelection", (Object)new JsonObject());
            this.putOpt(json.getJsonObject("rp"), "id", this.options.getRelyingParty().getId());
            this.putOpt(json.getJsonObject("rp"), "name", this.options.getRelyingParty().getName());
            this.putOpt(json.getJsonObject("rp"), "icon", this.options.getRelyingParty().getIcon());
            this.putOpt(json.getJsonObject("user"), "id", WebAuthnImpl.uUIDtoBase64Url(UUID.randomUUID()));
            this.putOpt(json.getJsonObject("user"), "name", user.getString("name"));
            this.putOpt(json.getJsonObject("user"), "displayName", user.getString("displayName"));
            this.putOpt(json.getJsonObject("user"), "icon", user.getString("icon"));
            for (PublicKeyCredential publicKeyCredential : this.options.getPubKeyCredParams()) {
                this.addOpt(json.getJsonArray("pubKeyCredParams"), new JsonObject().put("alg", (Object)publicKeyCredential.coseId()).put("type", (Object)"public-key"));
            }
            this.putOpt(json, "timeout", this.options.getTimeoutInMilliseconds());
            if (!authenticators.isEmpty()) {
                JsonArray transports = new JsonArray();
                for (AuthenticatorTransport transport : this.options.getTransports()) {
                    this.addOpt(transports, transport.toString());
                }
                JsonArray jsonArray = new JsonArray();
                for (Authenticator key : authenticators) {
                    JsonObject credentialDescriptor = new JsonObject().put("type", (Object)key.getType()).put("id", (Object)key.getCredID());
                    this.putOpt(credentialDescriptor, "transports", transports);
                    this.addOpt(jsonArray, credentialDescriptor);
                }
                this.putOpt(json, "excludeCredentials", jsonArray);
            }
            this.putOpt(json.getJsonObject("authenticatorSelection"), "requireResidentKey", this.options.getRequireResidentKey());
            this.putOpt(json.getJsonObject("authenticatorSelection"), "authenticatorAttachment", (Object)this.options.getAuthenticatorAttachment());
            this.putOpt(json.getJsonObject("authenticatorSelection"), "userVerification", (Object)this.options.getUserVerification());
            this.putOpt(json, "attestation", (Object)this.options.getAttestation());
            this.putOpt(json, "extensions", this.options.getExtensions());
            return json;
        });
    }

    @Override
    public Future<JsonObject> getCredentialsOptions(String name) {
        JsonObject json = new JsonObject().put("challenge", (Object)this.randomBase64URLBuffer(this.options.getChallengeLength()));
        this.putOpt(json, "timeout", this.options.getTimeoutInMilliseconds());
        this.putOpt(json, "rpId", this.options.getRelyingParty().getId());
        this.putOpt(json, "userVerification", (Object)this.options.getUserVerification());
        this.putOpt(json, "extensions", this.options.getExtensions());
        if (this.options.getRequireResidentKey() && name == null) {
            return Future.succeededFuture((Object)json);
        }
        return this.fetcher.apply(new Authenticator().setUserName(name)).compose(authenticators -> {
            if (authenticators.isEmpty()) {
                return Future.failedFuture((String)("No authenticators registered for user: " + name));
            }
            return Future.succeededFuture((Object)authenticators);
        }).map(authenticators -> {
            JsonArray allowCredentials = new JsonArray();
            JsonArray transports = new JsonArray();
            if (this.options.getTransports() != null) {
                for (AuthenticatorTransport transport : this.options.getTransports()) {
                    transports.add((Object)transport.toString());
                }
            }
            for (Authenticator key : authenticators) {
                String credId = key.getCredID();
                if (credId == null) continue;
                JsonObject credential = new JsonObject().put("type", (Object)"public-key").put("id", (Object)credId);
                this.putOpt(credential, "transports", transports);
                allowCredentials.add((Object)credential);
            }
            this.putOpt(json, "allowCredentials", allowCredentials);
            return json;
        });
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> handler) {
        this.authenticate(new WebAuthnCredentials(authInfo), handler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> handler) {
        try {
            WebAuthnCredentials authInfo = (WebAuthnCredentials)credentials;
            authInfo.checkValid(null);
            JsonObject webauthn = authInfo.getWebauthn();
            byte[] clientDataJSON = Codec.base64UrlDecode((String)webauthn.getJsonObject("response").getString("clientDataJSON"));
            JsonObject clientData = new JsonObject(Buffer.buffer((byte[])clientDataJSON));
            if (!authInfo.getChallenge().equals(clientData.getString("challenge"))) {
                handler.handle((Object)Future.failedFuture((String)"Challenges don't match!"));
                return;
            }
            if (authInfo.getOrigin() != null && !authInfo.getOrigin().equals(clientData.getString("origin"))) {
                handler.handle((Object)Future.failedFuture((String)"Origins don't match!"));
                return;
            }
            if (clientData.containsKey("tokenBinding")) {
                JsonObject tokenBinding = clientData.getJsonObject("tokenBinding");
                if (tokenBinding == null) {
                    handler.handle((Object)Future.failedFuture((String)"Invalid clientDataJSON.tokenBinding"));
                    return;
                }
                switch (tokenBinding.getString("status")) {
                    case "present": 
                    case "supported": 
                    case "not-supported": {
                        break;
                    }
                    default: {
                        handler.handle((Object)Future.failedFuture((String)"Invalid clientDataJSON.tokenBinding.status"));
                        return;
                    }
                }
            }
            String username = authInfo.getUsername();
            if (!clientData.containsKey("type")) {
                handler.handle((Object)Future.failedFuture((String)"Missing type on client data"));
                return;
            }
            switch (clientData.getString("type")) {
                case "webauthn.create": {
                    if (username == null) {
                        handler.handle((Object)Future.failedFuture((String)"username can't be null!"));
                        return;
                    }
                    try {
                        Authenticator authrInfo = this.verifyWebAuthNCreate(authInfo, clientDataJSON);
                        authrInfo.setUserName(username);
                        this.updater.apply(authrInfo).onFailure(err -> handler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(stored -> handler.handle((Object)Future.succeededFuture((Object)User.create((JsonObject)authrInfo.toJson()))));
                    }
                    catch (AttestationException | IOException | RuntimeException | NoSuchAlgorithmException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                    }
                    return;
                }
                case "webauthn.get": {
                    Authenticator query = new Authenticator();
                    if (this.options.getRequireResidentKey()) {
                        query.setCredID(webauthn.getString("id"));
                    } else {
                        if (username == null) {
                            handler.handle((Object)Future.failedFuture((String)"username can't be null!"));
                            return;
                        }
                        query.setUserName(username);
                    }
                    this.fetcher.apply(query).onFailure(err -> handler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(authenticators -> {
                        if (authenticators == null) {
                            authenticators = Collections.emptyList();
                        }
                        for (Authenticator authenticator : authenticators) {
                            if (!webauthn.getString("id").equals(authenticator.getCredID())) continue;
                            try {
                                long counter = this.verifyWebAuthNGet(authInfo, clientDataJSON, authenticator.toJson());
                                authenticator.setCounter(counter);
                                this.updater.apply(authenticator).onFailure(err -> handler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(stored -> handler.handle((Object)Future.succeededFuture((Object)User.create((JsonObject)authenticator.toJson()))));
                            }
                            catch (AttestationException | IOException | RuntimeException | NoSuchAlgorithmException e) {
                                handler.handle((Object)Future.failedFuture((Throwable)e));
                            }
                            return;
                        }
                        handler.handle((Object)Future.failedFuture((String)("Cannot find authenticator with id: " + webauthn.getString("id"))));
                    });
                    return;
                }
            }
            handler.handle((Object)Future.failedFuture((String)"Can not determine type of response!"));
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    private Authenticator verifyWebAuthNCreate(WebAuthnCredentials request, byte[] clientDataJSON) throws AttestationException, IOException, NoSuchAlgorithmException {
        JsonObject response = request.getWebauthn().getJsonObject("response");
        if (!response.containsKey("attestationObject")) {
            throw new AttestationException("Missing response.attestationObject");
        }
        try (CBOR decoder = new CBOR(Codec.base64UrlDecode((String)response.getString("attestationObject")));){
            JsonObject attestation = (JsonObject)decoder.read();
            AuthData authData = new AuthData(Codec.base64UrlDecode((String)attestation.getString("authData")));
            if (request.getDomain() != null && !MessageDigest.isEqual(authData.getRpIdHash(), Attestation.hash("SHA-256", request.getDomain().getBytes(StandardCharsets.UTF_8)))) {
                throw new AttestationException("WebAuthn rpIdHash invalid (the domain does not match the AuthData)");
            }
            switch (this.options.getUserVerification()) {
                case REQUIRED: {
                    if (authData.is(4) || authData.is(1)) break;
                    throw new AttestationException("User was either not verified or present during credentials creation");
                }
                case PREFERRED: {
                    if (authData.is(4) || authData.is(1)) break;
                    LOG.warn((Object)"User was either not verified or present during credentials creation");
                    break;
                }
                case DISCOURAGED: {
                    if (!authData.is(4) && !authData.is(1)) break;
                    LOG.info((Object)"User was either verified or present during credentials creation");
                }
            }
            String fmt = attestation.getString("fmt");
            Attestation verifier = this.attestations.get(fmt);
            if (verifier == null) {
                throw new AttestationException("Unknown attestation fmt: " + fmt);
            }
            if (!authData.is(64)) {
                throw new AttestationException("WebAuthn response does not contain attestation data!");
            }
            AttestationCertificates certificates = verifier.validate(this.options, this.mds.metadata(), clientDataJSON, attestation, authData);
            Authenticator authenticator = new Authenticator().setFmt(fmt).setAaguid(authData.getAaguidString()).setPublicKey(Codec.base64UrlEncode((byte[])authData.getCredentialPublicKey())).setCounter(authData.getSignCounter()).setCredID(Codec.base64UrlEncode((byte[])authData.getCredentialId())).setAttestationCertificates(certificates);
            return authenticator;
        }
    }

    private long verifyWebAuthNGet(WebAuthnCredentials request, byte[] clientDataJSON, JsonObject credential) throws IOException, AttestationException, NoSuchAlgorithmException {
        JsonObject response = request.getWebauthn().getJsonObject("response");
        byte[] authenticatorData = Codec.base64UrlDecode((String)response.getString("authenticatorData"));
        AuthData authData = new AuthData(authenticatorData);
        if (request.getDomain() != null && !MessageDigest.isEqual(authData.getRpIdHash(), Attestation.hash("SHA-256", request.getDomain().getBytes(StandardCharsets.UTF_8)))) {
            throw new AttestationException("WebAuthn rpIdHash invalid (the domain does not match the AuthData)");
        }
        switch (this.options.getUserVerification()) {
            case REQUIRED: {
                if (authData.is(4) && authData.is(1)) break;
                throw new AttestationException("User was either not verified or not present during credentials creation");
            }
            case PREFERRED: {
                if (authData.is(4) || authData.is(1)) break;
                LOG.warn((Object)"User was either not verified or present during credentials creation");
                break;
            }
            case DISCOURAGED: {
                if (!authData.is(4) && !authData.is(1)) break;
                LOG.info((Object)"User was either verified or present during credentials creation");
            }
        }
        byte[] clientDataHash = Attestation.hash("SHA-256", clientDataJSON);
        Buffer signatureBase = Buffer.buffer().appendBytes(authenticatorData).appendBytes(clientDataHash);
        try (CBOR decoder = new CBOR(Codec.base64UrlDecode((String)credential.getString("publicKey")));){
            JWK publicKey = CWK.toJWK((Iterable)((Iterable)decoder.read()));
            byte[] signature = Codec.base64UrlDecode((String)response.getString("signature"));
            JWS jws = new JWS(publicKey);
            if (!jws.verify(signature, signatureBase.getBytes())) {
                LOG.warn((Object)("Failed to verify signature for key: " + credential.getString("publicKey")));
                throw new AttestationException("Failed to verify the signature!");
            }
            if ((authData.getSignCounter() != 0L || credential.getLong("counter") != 0L) && authData.getSignCounter() != 0L && authData.getSignCounter() <= credential.getLong("counter", Long.valueOf(0L))) {
                throw new AttestationException("Authenticator counter did not increase!");
            }
            long l = authData.getSignCounter();
            return l;
        }
    }

    @Override
    public MetaDataService metaDataService() {
        return this.mds;
    }
}

