/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.auth.webauthn.WebAuthnCredentials;
import java.util.Base64;
import java.util.Map;

public class WebAuthnCredentialsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, WebAuthnCredentials obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "challenge": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setChallenge((String)member.getValue());
                    break;
                }
                case "domain": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDomain((String)member.getValue());
                    break;
                }
                case "origin": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setOrigin((String)member.getValue());
                    break;
                }
                case "username": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUsername((String)member.getValue());
                    break;
                }
                case "webauthn": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setWebauthn(((JsonObject)member.getValue()).copy());
                }
            }
        }
    }

    public static void toJson(WebAuthnCredentials obj, JsonObject json) {
        WebAuthnCredentialsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(WebAuthnCredentials obj, Map<String, Object> json) {
        if (obj.getChallenge() != null) {
            json.put("challenge", obj.getChallenge());
        }
        if (obj.getDomain() != null) {
            json.put("domain", obj.getDomain());
        }
        if (obj.getOrigin() != null) {
            json.put("origin", obj.getOrigin());
        }
        if (obj.getUsername() != null) {
            json.put("username", obj.getUsername());
        }
        if (obj.getWebauthn() != null) {
            json.put("webauthn", obj.getWebauthn());
        }
    }
}

