/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.impl.asn.ASN1;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.attestation.tpm.CertInfo;
import io.vertx.ext.auth.webauthn.impl.attestation.tpm.PubArea;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaData;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

public class TPMAttestation
implements Attestation {
    public static final int TPM_ALG_ERROR = 0;
    public static final int TPM_ALG_RSA = 1;
    public static final int TPM_ALG_SHA = 4;
    public static final int TPM_ALG_SHA1 = 4;
    public static final int TPM_ALG_HMAC = 5;
    public static final int TPM_ALG_AES = 6;
    public static final int TPM_ALG_MGF1 = 7;
    public static final int TPM_ALG_KEYEDHASH = 8;
    public static final int TPM_ALG_XOR = 10;
    public static final int TPM_ALG_SHA256 = 11;
    public static final int TPM_ALG_SHA384 = 12;
    public static final int TPM_ALG_SHA512 = 13;
    public static final int TPM_ALG_NULL = 16;
    public static final int TPM_ALG_SM3_256 = 18;
    public static final int TPM_ALG_SM4 = 19;
    public static final int TPM_ALG_RSASSA = 20;
    public static final int TPM_ALG_RSAES = 21;
    public static final int TPM_ALG_RSAPSS = 22;
    public static final int TPM_ALG_OAEP = 23;
    public static final int TPM_ALG_ECDSA = 24;
    public static final int TPM_ALG_ECDH = 25;
    public static final int TPM_ALG_ECDAA = 26;
    public static final int TPM_ALG_SM2 = 27;
    public static final int TPM_ALG_ECSCHNORR = 28;
    public static final int TPM_ALG_ECMQV = 29;
    public static final int TPM_ALG_KDF1_SP800_56A = 32;
    public static final int TPM_ALG_KDF2 = 33;
    public static final int TPM_ALG_KDF1_SP800_108 = 34;
    public static final int TPM_ALG_ECC = 35;
    public static final int TPM_ALG_SYMCIPHER = 37;
    public static final int TPM_ALG_CAMELLIA = 38;
    public static final int TPM_ALG_CTR = 64;
    public static final int TPM_ALG_OFB = 65;
    public static final int TPM_ALG_CBC = 66;
    public static final int TPM_ALG_CFB = 67;
    public static final int TPM_ALG_ECB = 68;
    public static final int TPM_ST_ATTEST_CERTIFY = 32791;
    private static final List<String> TPM_MANUFACTURERS = Arrays.asList("id:414D4400", "id:41544D4C", "id:4252434D", "id:49424d00", "id:49465800", "id:494E5443", "id:4C454E00", "id:4E534D20", "id:4E545A00", "id:4E544300", "id:51434F4D", "id:534D5343", "id:53544D20", "id:534D534E", "id:534E5300", "id:54584E00", "id:57454300", "id:524F4343", "id:FFFFF1D0");

    @Override
    public String fmt() {
        return "tpm";
    }

    @Override
    public AttestationCertificates validate(WebAuthnOptions options, MetaData metadata, byte[] clientDataJSON, JsonObject attestation, AuthData authData) throws AttestationException {
        try {
            JsonObject statement;
            String alg;
            CertInfo certInfo;
            byte[] clientDataHash = Attestation.hash("SHA-256", clientDataJSON);
            JsonObject attStmt = attestation.getJsonObject("attStmt");
            if (!attStmt.getString("ver").equals("2.0")) {
                throw new AttestationException("expected TPM version 2.0");
            }
            PubArea pubArea = new PubArea(Codec.base64UrlDecode((String)attStmt.getString("pubArea")));
            JsonObject cosePublicKey = authData.getCredentialPublicKeyJson();
            if (pubArea.getType() == 1) {
                byte[] n = Codec.base64UrlDecode((String)cosePublicKey.getString("-1"));
                byte[] e = Codec.base64UrlDecode((String)cosePublicKey.getString("-2"));
                long exponent = pubArea.getExponent();
                if (exponent == 0L) {
                    exponent = 65537L;
                }
                if (exponent != (long)(e[0] + (e[1] << 8) + (e[2] << 16))) {
                    throw new AttestationException("Unexpected public key exp");
                }
                if (!MessageDigest.isEqual(pubArea.getUnique(), n)) {
                    throw new AttestationException("PubArea unique is not same as credentialPublicKey");
                }
            } else if (pubArea.getType() == 35) {
                byte[] crv = Codec.base64UrlDecode((String)cosePublicKey.getString("-1"));
                byte[] x = Codec.base64UrlDecode((String)cosePublicKey.getString("-2"));
                byte[] y = Codec.base64UrlDecode((String)cosePublicKey.getString("-3"));
                if (pubArea.getCurveID() != crv[0] + (crv[1] << 8)) {
                    throw new AttestationException("Unexpected public key crv");
                }
                if (!MessageDigest.isEqual(pubArea.getUnique(), Buffer.buffer().appendBytes(x).appendBytes(y).getBytes())) {
                    throw new AttestationException("PubArea unique is not same as public key x and y");
                }
            } else {
                throw new AttestationException("Unsupported pubArea.type" + pubArea.getType());
            }
            if ((certInfo = new CertInfo(Codec.base64UrlDecode((String)attStmt.getString("certInfo")))).getMagic() != 4283712327L) {
                throw new AttestationException("certInfo had bad magic number");
            }
            if (certInfo.getType() != 32791) {
                throw new AttestationException("Wrong type. expected 'TPM_ST_ATTEST_CERTIFY'");
            }
            switch (certInfo.getNameAlg()) {
                case 4: {
                    alg = "SHA1";
                    break;
                }
                case 11: {
                    alg = "SHA-256";
                    break;
                }
                case 12: {
                    alg = "SHA-384";
                    break;
                }
                case 13: {
                    alg = "SHA-512";
                    break;
                }
                default: {
                    throw new AttestationException("Unsupported algorithm: " + pubArea.getNameAlg());
                }
            }
            byte[] pubAreaHash = Attestation.hash(alg, Codec.base64UrlDecode((String)attStmt.getString("pubArea")));
            byte[] attestedName = Buffer.buffer().appendByte(certInfo.getAttestedName()[0]).appendByte(certInfo.getAttestedName()[1]).appendBytes(pubAreaHash).getBytes();
            if (!MessageDigest.isEqual(certInfo.getAttestedName(), attestedName)) {
                throw new AttestationException("Attested name comparison failed");
            }
            byte[] attToBeSigned = Buffer.buffer().appendBytes(authData.getRaw()).appendBytes(clientDataHash).getBytes();
            switch (attStmt.getInteger("alg")) {
                case -257: 
                case -47: 
                case -37: 
                case -7: {
                    alg = "SHA-256";
                    break;
                }
                case -258: 
                case -38: 
                case -35: {
                    alg = "SHA-384";
                    break;
                }
                case -259: 
                case -39: 
                case -36: {
                    alg = "SHA-512";
                    break;
                }
                case -65535: {
                    alg = "SHA1";
                    break;
                }
                default: {
                    throw new AttestationException("Unsupported algorithm: " + attStmt.getInteger("alg"));
                }
            }
            byte[] attToBeSignedHash = Attestation.hash(alg, attToBeSigned);
            if (!MessageDigest.isEqual(certInfo.getExtraData(), attToBeSignedHash)) {
                throw new AttestationException("CertInfo extra data did not equal hashed attestation");
            }
            List<X509Certificate> x5c = Attestation.parseX5c(attStmt.getJsonArray("x5c"));
            if (x5c.size() == 0) {
                throw new AttestationException("no certificates in x5c field");
            }
            X509Certificate leafCert = x5c.get(0);
            CertificateHelper.CertInfo leafCertInfo = CertificateHelper.getCertInfo((X509Certificate)leafCert);
            if (leafCertInfo.version() != 3) {
                throw new AttestationException("Batch certificate version MUST be 3(ASN1 2)");
            }
            if (leafCertInfo.basicConstraintsCA() != -1) {
                throw new AttestationException("Batch certificate basic constraints CA MUST be -1");
            }
            if (!leafCertInfo.isEmpty()) {
                throw new AttestationException("Certificate subject was not empty");
            }
            leafCert.checkValidity();
            byte[] subjectAltName = leafCert.getExtensionValue("2.5.29.17");
            ASN1.ASN extension = ASN1.parseASN1((byte[])subjectAltName);
            if (!extension.is(4)) {
                throw new AttestationException("2.5.29.17 Extension is not an ASN.1 OCTET_STRING");
            }
            ASN1.ASN root = ASN1.parseASN1((byte[])extension.binary(0));
            if (!root.is(16)) {
                throw new AttestationException("2.5.29.17 Extension OCTET_STRING is not an ASN.1 SEQUENCE");
            }
            ASN1.ASN set = root.object(0, 132).object(0, 16).object(0, 17);
            for (int i = 0; i < set.length(); ++i) {
                ASN1.ASN el = set.object(i);
                ASN1.ASN oid = el.object(0, 6);
                ASN1.ASN val = el.object(1, 12);
                if (!MessageDigest.isEqual(oid.binary(0), new byte[]{103, -127, 5, 2, 1}) || TPM_MANUFACTURERS.contains(new String(val.binary(0), StandardCharsets.UTF_8))) continue;
                throw new AttestationException("Unknown Manufacturer id");
            }
            byte[] extKeyUsage = leafCert.getExtensionValue("2.5.29.37");
            extension = ASN1.parseASN1((byte[])extKeyUsage);
            if (!extension.is(4)) {
                throw new AttestationException("2.5.29.37 Extension is not an ASN.1 OCTET_STRING");
            }
            root = ASN1.parseASN1((byte[])extension.binary(0));
            if (!root.is(16)) {
                throw new AttestationException("2.5.29.37 Extension OCTET_STRING is not an ASN.1 SEQUENCE");
            }
            boolean found = false;
            for (int i = 0; i < root.length(); ++i) {
                ASN1.ASN el = root.object(i, 6);
                if (!MessageDigest.isEqual(el.binary(0), new byte[]{103, -127, 5, 8, 3})) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new AttestationException("2.5.29.37 Extension SEQUENCE does not contain OBJECT_IDENTIFIER 2.23.133.8.3");
            }
            byte[] idFidoGenCeAaguid = leafCert.getExtensionValue("1.3.6.1.4.1.45724.1.1.4");
            if (idFidoGenCeAaguid != null) {
                extension = ASN1.parseASN1((byte[])idFidoGenCeAaguid);
                if (!extension.is(4)) {
                    throw new AttestationException("1.3.6.1.4.1.45724.1.1.4 Extension is not an ASN.1 OCTECT string!");
                }
                if (!(extension = ASN1.parseASN1((byte[])extension.binary(0))).is(4)) {
                    throw new AttestationException("1.3.6.1.4.1.45724.1.1.4 Extension is not an ASN.1 OCTECT string!");
                }
                if (!MessageDigest.isEqual(extension.binary(0), authData.getAaguid())) {
                    throw new AttestationException("Certificate id-fido-gen-ce-aaguid extension does not match authData");
                }
            }
            if ((statement = metadata.verifyMetadata(authData.getAaguidString(), PublicKeyCredential.valueOf(attStmt.getInteger("alg")), x5c, false)) != null && !MetaData.statementAttestationTypesContains(statement, 15882) && !MetaData.statementAttestationTypesContains(statement, 15879)) {
                throw new AttestationException("Metadata does not indicate support for attca/basic_full attestations");
            }
            Attestation.verifySignature(PublicKeyCredential.valueOf(attStmt.getInteger("alg")), leafCert, Codec.base64UrlDecode((String)attStmt.getString("sig")), Codec.base64UrlDecode((String)attStmt.getString("certInfo")));
            return new AttestationCertificates().setAlg(PublicKeyCredential.valueOf(attStmt.getInteger("alg"))).setX5c(attStmt.getJsonArray("x5c"));
        }
        catch (MetaDataException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new AttestationException(e);
        }
    }
}

