/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation.tpm;

import io.vertx.core.buffer.Buffer;

public class PubArea {
    private final int type;
    private final int nameAlg;
    private final long objectAttributes;
    private final byte[] authPolicy;
    private final int symmetric;
    private final int scheme;
    private final byte[] unique;
    private int keyBits;
    private long exponent;
    private int curveID;
    private int kdf;

    public PubArea(byte[] data) {
        this(Buffer.buffer((byte[])data));
    }

    public PubArea(Buffer pubBuffer) {
        int pos = 0;
        this.type = pubBuffer.getUnsignedShort(pos);
        this.nameAlg = pubBuffer.getUnsignedShort(pos += 2);
        this.objectAttributes = pubBuffer.getUnsignedInt(pos += 2);
        int len = pubBuffer.getUnsignedShort(pos += 4);
        this.authPolicy = pubBuffer.getBytes(pos += 2, pos + len);
        pos += len;
        if (this.type == 1) {
            this.symmetric = pubBuffer.getUnsignedShort(pos);
            this.scheme = pubBuffer.getUnsignedShort(pos += 2);
            this.keyBits = pubBuffer.getUnsignedShort(pos += 2);
            this.exponent = pubBuffer.getUnsignedInt(pos += 2);
            pos += 4;
        } else if (this.type == 35) {
            this.symmetric = pubBuffer.getUnsignedShort(pos);
            this.scheme = pubBuffer.getUnsignedShort(pos += 2);
            this.curveID = pubBuffer.getUnsignedShort(pos += 2);
            this.kdf = pubBuffer.getUnsignedShort(pos += 4);
            pos += 2;
        } else {
            throw new IllegalArgumentException("Unexpected type: " + this.type);
        }
        len = pubBuffer.getUnsignedShort(pos);
        this.unique = pubBuffer.getBytes(pos += 2, pos + len);
    }

    public int getType() {
        return this.type;
    }

    public int getNameAlg() {
        return this.nameAlg;
    }

    public long getObjectAttributes() {
        return this.objectAttributes;
    }

    public byte[] getAuthPolicy() {
        return this.authPolicy;
    }

    public int getSymmetric() {
        return this.symmetric;
    }

    public int getScheme() {
        return this.scheme;
    }

    public int getKeyBits() {
        return this.keyBits;
    }

    public long getExponent() {
        return this.exponent;
    }

    public int getCurveID() {
        return this.curveID;
    }

    public int getKdf() {
        return this.kdf;
    }

    public byte[] getUnique() {
        return this.unique;
    }
}

