/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.ext.auth.webauthn.MetaDataService;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.WebAuthnImpl;
import java.util.List;
import java.util.function.Function;

@VertxGen
public interface WebAuthn
extends AuthenticationProvider {
    public static WebAuthn create(Vertx vertx) {
        return WebAuthn.create(vertx, new WebAuthnOptions());
    }

    public static WebAuthn create(Vertx vertx, WebAuthnOptions options) {
        return new WebAuthnImpl(vertx, options);
    }

    @Fluent
    default public WebAuthn createCredentialsOptions(JsonObject user, Handler<AsyncResult<JsonObject>> handler) {
        this.createCredentialsOptions(user).onComplete(handler);
        return this;
    }

    public Future<JsonObject> createCredentialsOptions(JsonObject var1);

    @Fluent
    default public WebAuthn getCredentialsOptions(@Nullable String name, Handler<AsyncResult<JsonObject>> handler) {
        this.getCredentialsOptions(name).onComplete(handler);
        return this;
    }

    public Future<JsonObject> getCredentialsOptions(@Nullable String var1);

    @Fluent
    public WebAuthn authenticatorFetcher(Function<Authenticator, Future<List<Authenticator>>> var1);

    @Fluent
    public WebAuthn authenticatorUpdater(Function<Authenticator, Future<Void>> var1);

    public MetaDataService metaDataService();
}

