/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import java.util.ArrayList;
import java.util.Map;

public class AttestationCertificatesConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, AttestationCertificates obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "alg": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAlg(PublicKeyCredential.valueOf((String)member.getValue()));
                    break;
                }
                case "x5c": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setX5c(list);
                }
            }
        }
    }

    static void toJson(AttestationCertificates obj, JsonObject json) {
        AttestationCertificatesConverter.toJson(obj, json.getMap());
    }

    static void toJson(AttestationCertificates obj, Map<String, Object> json) {
        if (obj.getAlg() != null) {
            json.put("alg", obj.getAlg().name());
        }
        if (obj.getX5c() != null) {
            JsonArray array = new JsonArray();
            obj.getX5c().forEach(item -> array.add(item));
            json.put("x5c", array);
        }
    }
}

