/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.webauthn.Attestation;
import io.vertx.ext.auth.webauthn.AuthenticatorAttachment;
import io.vertx.ext.auth.webauthn.AuthenticatorTransport;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.RelyingParty;
import io.vertx.ext.auth.webauthn.ResidentKey;
import io.vertx.ext.auth.webauthn.UserVerification;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class WebAuthnOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, WebAuthnOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "relyingParty": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setRelyingParty(new RelyingParty((JsonObject)member.getValue()));
                    break;
                }
                case "transports": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<AuthenticatorTransport> list = new ArrayList<AuthenticatorTransport>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(AuthenticatorTransport.valueOf((String)item));
                        }
                    });
                    obj.setTransports(list);
                    break;
                }
                case "attestation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAttestation(Attestation.valueOf((String)member.getValue()));
                    break;
                }
                case "residentKey": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setResidentKey(ResidentKey.valueOf((String)member.getValue()));
                    break;
                }
                case "pubKeyCredParams": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<AuthenticatorTransport> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((AuthenticatorTransport)((Object)PublicKeyCredential.valueOf((String)item)));
                        }
                    });
                    obj.setPubKeyCredParams(list);
                    break;
                }
                case "authenticatorAttachment": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAuthenticatorAttachment(AuthenticatorAttachment.valueOf((String)member.getValue()));
                    break;
                }
                case "requireResidentKey": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRequireResidentKey((Boolean)member.getValue());
                    break;
                }
                case "userVerification": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUserVerification(UserVerification.valueOf((String)member.getValue()));
                    break;
                }
                case "timeoutInMilliseconds": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTimeoutInMilliseconds(((Number)member.getValue()).longValue());
                    break;
                }
                case "challengeLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setChallengeLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "extensions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setExtensions(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "rootCertificates": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setRootCertificates(map);
                    break;
                }
                case "rootCrls": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<AuthenticatorTransport> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((AuthenticatorTransport)((Object)((String)item)));
                        }
                    });
                    obj.setRootCrls(list);
                    break;
                }
                case "relaxedSafetyNetIntegrityVeridict": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRelaxedSafetyNetIntegrityVeridict((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(WebAuthnOptions obj, JsonObject json) {
        WebAuthnOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(WebAuthnOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getRelyingParty() != null) {
            json.put("relyingParty", obj.getRelyingParty().toJson());
        }
        if (obj.getTransports() != null) {
            array = new JsonArray();
            obj.getTransports().forEach(item -> array.add((Object)item.name()));
            json.put("transports", array);
        }
        if (obj.getAttestation() != null) {
            json.put("attestation", obj.getAttestation().name());
        }
        if (obj.getResidentKey() != null) {
            json.put("residentKey", obj.getResidentKey().name());
        }
        if (obj.getPubKeyCredParams() != null) {
            array = new JsonArray();
            obj.getPubKeyCredParams().forEach(item -> array.add((Object)item.name()));
            json.put("pubKeyCredParams", array);
        }
        if (obj.getAuthenticatorAttachment() != null) {
            json.put("authenticatorAttachment", obj.getAuthenticatorAttachment().name());
        }
        if (obj.getRequireResidentKey() != null) {
            json.put("requireResidentKey", obj.getRequireResidentKey());
        }
        if (obj.getUserVerification() != null) {
            json.put("userVerification", obj.getUserVerification().name());
        }
        if (obj.getTimeoutInMilliseconds() != null) {
            json.put("timeoutInMilliseconds", obj.getTimeoutInMilliseconds());
        }
        json.put("challengeLength", obj.getChallengeLength());
        if (obj.getExtensions() != null) {
            json.put("extensions", obj.getExtensions());
        }
        json.put("relaxedSafetyNetIntegrityVeridict", obj.isRelaxedSafetyNetIntegrityVeridict());
    }
}

