/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.impl.cose.CWK;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWS;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.ext.auth.webauthn.AuthenticatorTransport;
import io.vertx.ext.auth.webauthn.MetaDataService;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthn;
import io.vertx.ext.auth.webauthn.WebAuthnCredentials;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.CBOR;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataServiceImpl;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Function;

public class WebAuthnImpl
implements WebAuthn {
    private static final Logger LOG = LoggerFactory.getLogger(WebAuthn.class);
    private final Map<String, Attestation> attestations = new HashMap<String, Attestation>();
    private final VertxContextPRNG random;
    private final WebAuthnOptions options;
    private final MetaDataServiceImpl mds;
    private Function<Authenticator, Future<List<Authenticator>>> fetcher = authr -> Future.failedFuture((String)"Fetcher function not available");
    private Function<Authenticator, Future<Void>> updater = authr -> Future.failedFuture((String)"Updater function not available");

    public WebAuthnImpl(Vertx vertx, WebAuthnOptions options) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.options = options;
        if (options == null) {
            throw new IllegalArgumentException("options cannot be null!");
        }
        if (options.getRelyingParty() == null) {
            throw new IllegalArgumentException("options.relyingParty cannot be null!");
        }
        if (options.getRelyingParty().getName() == null) {
            throw new IllegalArgumentException("options.relyingParty.name cannot be null!");
        }
        this.mds = new MetaDataServiceImpl(vertx, options);
        ServiceLoader<Attestation> attestationServiceLoader = ServiceLoader.load(Attestation.class);
        for (Attestation att : attestationServiceLoader) {
            this.attestations.put(att.fmt(), att);
        }
    }

    private String randomBase64URLBuffer(int length) {
        byte[] buff = new byte[length];
        this.random.nextBytes(buff);
        return Codec.base64UrlEncode((byte[])buff);
    }

    private void putOpt(JsonObject json, String key, Object value) {
        if (value != null) {
            if (value instanceof Enum) {
                json.put(key, (Object)value.toString());
                return;
            }
            if (value instanceof JsonObject && ((JsonObject)value).isEmpty()) {
                return;
            }
            if (value instanceof JsonArray && ((JsonArray)value).isEmpty()) {
                return;
            }
            json.put(key, value);
        }
    }

    private void addOpt(JsonArray json, Object value) {
        if (value != null) {
            if (value instanceof Enum) {
                json.add((Object)value.toString());
                return;
            }
            if (value instanceof JsonObject && ((JsonObject)value).isEmpty()) {
                return;
            }
            if (value instanceof JsonArray && ((JsonArray)value).isEmpty()) {
                return;
            }
            json.add(value);
        }
    }

    private static String uUIDtoBase64Url(UUID uuid) {
        Buffer buffer = Buffer.buffer((int)16);
        buffer.setLong(0, uuid.getMostSignificantBits());
        buffer.setLong(8, uuid.getLeastSignificantBits());
        return Codec.base64UrlEncode((byte[])buffer.getBytes());
    }

    @Override
    public WebAuthn authenticatorFetcher(Function<Authenticator, Future<List<Authenticator>>> fetcher) {
        if (fetcher == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public WebAuthn authenticatorUpdater(Function<Authenticator, Future<Void>> updater) {
        if (updater == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        this.updater = updater;
        return this;
    }

    @Override
    public Future<JsonObject> createCredentialsOptions(JsonObject user) {
        return this.fetcher.apply(new Authenticator().setUserName(user.getString("name"))).map(authenticators -> {
            JsonObject json = new JsonObject().put("rp", (Object)new JsonObject()).put("user", (Object)new JsonObject()).put("challenge", (Object)this.randomBase64URLBuffer(this.options.getChallengeLength())).put("pubKeyCredParams", (Object)new JsonArray()).put("authenticatorSelection", (Object)new JsonObject());
            this.putOpt(json.getJsonObject("rp"), "id", this.options.getRelyingParty().getId());
            this.putOpt(json.getJsonObject("rp"), "name", this.options.getRelyingParty().getName());
            this.putOpt(json.getJsonObject("user"), "id", WebAuthnImpl.uUIDtoBase64Url(UUID.randomUUID()));
            this.putOpt(json.getJsonObject("user"), "name", user.getString("name"));
            this.putOpt(json.getJsonObject("user"), "displayName", user.getString("displayName"));
            this.putOpt(json.getJsonObject("user"), "icon", user.getString("icon"));
            for (PublicKeyCredential publicKeyCredential : this.options.getPubKeyCredParams()) {
                this.addOpt(json.getJsonArray("pubKeyCredParams"), new JsonObject().put("alg", (Object)publicKeyCredential.coseId()).put("type", (Object)"public-key"));
            }
            this.putOpt(json, "timeout", this.options.getTimeoutInMilliseconds());
            if (!authenticators.isEmpty()) {
                JsonArray transports = new JsonArray();
                for (AuthenticatorTransport transport : this.options.getTransports()) {
                    this.addOpt(transports, transport.toString());
                }
                JsonArray jsonArray = new JsonArray();
                for (Authenticator key : authenticators) {
                    JsonObject credentialDescriptor = new JsonObject().put("type", (Object)key.getType()).put("id", (Object)key.getCredID());
                    this.putOpt(credentialDescriptor, "transports", transports);
                    this.addOpt(jsonArray, credentialDescriptor);
                }
                this.putOpt(json, "excludeCredentials", jsonArray);
            }
            this.putOpt(json.getJsonObject("authenticatorSelection"), "authenticatorAttachment", (Object)this.options.getAuthenticatorAttachment());
            this.putOpt(json.getJsonObject("authenticatorSelection"), "residentKey", (Object)this.options.getResidentKey());
            this.putOpt(json.getJsonObject("authenticatorSelection"), "requireResidentKey", this.options.getRequireResidentKey());
            this.putOpt(json.getJsonObject("authenticatorSelection"), "userVerification", (Object)this.options.getUserVerification());
            this.putOpt(json, "attestation", (Object)this.options.getAttestation());
            this.putOpt(json, "extensions", this.options.getExtensions());
            return json;
        });
    }

    @Override
    public Future<JsonObject> getCredentialsOptions(String name) {
        JsonObject json = new JsonObject().put("challenge", (Object)this.randomBase64URLBuffer(this.options.getChallengeLength()));
        this.putOpt(json, "timeout", this.options.getTimeoutInMilliseconds());
        this.putOpt(json, "rpId", this.options.getRelyingParty().getId());
        this.putOpt(json, "userVerification", (Object)this.options.getUserVerification());
        this.putOpt(json, "extensions", this.options.getExtensions());
        switch (this.options.getResidentKey()) {
            case REQUIRED: 
            case PREFERRED: {
                return Future.succeededFuture((Object)json);
            }
            case DISCOURAGED: {
                if (name != null) break;
                return Future.failedFuture((String)"Name is required for non RK requests");
            }
        }
        return this.fetcher.apply(new Authenticator().setUserName(name)).compose(authenticators -> {
            if (authenticators.isEmpty()) {
                return Future.failedFuture((String)("No authenticators registered for user: " + name));
            }
            return Future.succeededFuture((Object)authenticators);
        }).map(authenticators -> {
            JsonArray allowCredentials = new JsonArray();
            JsonArray transports = new JsonArray();
            if (this.options.getTransports() != null) {
                for (AuthenticatorTransport transport : this.options.getTransports()) {
                    transports.add((Object)transport.toString());
                }
            }
            for (Authenticator key : authenticators) {
                String credId = key.getCredID();
                if (credId == null) continue;
                JsonObject credential = new JsonObject().put("type", (Object)"public-key").put("id", (Object)credId);
                this.putOpt(credential, "transports", transports);
                allowCredentials.add((Object)credential);
            }
            this.putOpt(json, "allowCredentials", allowCredentials);
            return json;
        });
    }

    /*
     * Exception decompiling
     */
    public Future<User> authenticate(Credentials credentials) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Authenticator verifyWebAuthNCreate(WebAuthnCredentials request, byte[] clientDataJSON) throws AttestationException, IOException, NoSuchAlgorithmException {
        JsonObject response = request.getWebauthn().getJsonObject("response");
        if (!response.containsKey("attestationObject")) {
            throw new AttestationException("Missing response.attestationObject");
        }
        try (CBOR decoder = new CBOR(Codec.base64UrlDecode((String)response.getString("attestationObject")));){
            JsonObject attestation = (JsonObject)decoder.read();
            AuthData authData = new AuthData(Codec.base64UrlDecode((String)attestation.getString("authData")));
            if (request.getDomain() != null && !MessageDigest.isEqual(authData.getRpIdHash(), Attestation.hash("SHA-256", request.getDomain().getBytes(StandardCharsets.UTF_8)))) {
                throw new AttestationException("WebAuthn rpIdHash invalid (the domain does not match the AuthData)");
            }
            switch (this.options.getUserVerification()) {
                case REQUIRED: {
                    if (authData.is(4) || authData.is(1)) break;
                    throw new AttestationException("User was either not verified or present during credentials creation");
                }
                case PREFERRED: {
                    if (authData.is(4) || authData.is(1)) break;
                    LOG.warn((Object)"User was either not verified or present during credentials creation");
                    break;
                }
                case DISCOURAGED: {
                    if (!authData.is(4) && !authData.is(1)) break;
                    LOG.info((Object)"User was either verified or present during credentials creation");
                }
            }
            String fmt = attestation.getString("fmt");
            Attestation verifier = this.attestations.get(fmt);
            if (verifier == null) {
                throw new AttestationException("Unknown attestation fmt: " + fmt);
            }
            if (!authData.is(64)) {
                throw new AttestationException("WebAuthn response does not contain attestation data!");
            }
            AttestationCertificates certificates = verifier.validate(this.options, this.mds.metadata(), clientDataJSON, attestation, authData);
            Authenticator authenticator = new Authenticator().setFmt(fmt).setAaguid(authData.getAaguidString()).setPublicKey(Codec.base64UrlEncode((byte[])authData.getCredentialPublicKey())).setCounter(authData.getSignCounter()).setCredID(Codec.base64UrlEncode((byte[])authData.getCredentialId())).setAttestationCertificates(certificates).setFlags(authData.getFlags());
            return authenticator;
        }
    }

    private long verifyWebAuthNGet(WebAuthnCredentials request, byte[] clientDataJSON, JsonObject credential) throws IOException, AttestationException, NoSuchAlgorithmException {
        JsonObject response = request.getWebauthn().getJsonObject("response");
        byte[] authenticatorData = Codec.base64UrlDecode((String)response.getString("authenticatorData"));
        AuthData authData = new AuthData(authenticatorData);
        if (request.getDomain() != null && !MessageDigest.isEqual(authData.getRpIdHash(), Attestation.hash("SHA-256", request.getDomain().getBytes(StandardCharsets.UTF_8)))) {
            throw new AttestationException("WebAuthn rpIdHash invalid (the domain does not match the AuthData)");
        }
        switch (this.options.getUserVerification()) {
            case REQUIRED: {
                if (authData.is(4) && authData.is(1)) break;
                throw new AttestationException("User was either not verified or not present during credentials creation");
            }
            case PREFERRED: {
                if (authData.is(4) || authData.is(1)) break;
                LOG.warn((Object)"User was either not verified or present during credentials creation");
                break;
            }
            case DISCOURAGED: {
                if (!authData.is(4) && !authData.is(1)) break;
                LOG.info((Object)"User was either verified or present during credentials creation");
            }
        }
        byte[] clientDataHash = Attestation.hash("SHA-256", clientDataJSON);
        Buffer signatureBase = Buffer.buffer().appendBytes(authenticatorData).appendBytes(clientDataHash);
        try (CBOR decoder = new CBOR(Codec.base64UrlDecode((String)credential.getString("publicKey")));){
            JWK publicKey = CWK.toJWK((Iterable)((Iterable)decoder.read()));
            byte[] signature = Codec.base64UrlDecode((String)response.getString("signature"));
            JWS jws = new JWS(publicKey);
            if (!jws.verify(signature, signatureBase.getBytes())) {
                LOG.warn((Object)("Failed to verify signature for key: " + credential.getString("publicKey")));
                throw new AttestationException("Failed to verify the signature!");
            }
            if ((authData.getSignCounter() != 0L || credential.getLong("counter") != 0L) && authData.getSignCounter() != 0L && authData.getSignCounter() <= credential.getLong("counter", Long.valueOf(0L))) {
                throw new AttestationException("Authenticator counter did not increase!");
            }
            long l = authData.getSignCounter();
            return l;
        }
    }

    @Override
    public MetaDataService metaDataService() {
        return this.mds;
    }

    private /* synthetic */ Future lambda$authenticate$7(JsonObject webauthn, WebAuthnCredentials authInfo, byte[] clientDataJSON, List authenticators) {
        if (authenticators != null) {
            for (Authenticator authenticator : authenticators) {
                if (!webauthn.getString("id").equals(authenticator.getCredID())) continue;
                try {
                    long counter = this.verifyWebAuthNGet(authInfo, clientDataJSON, authenticator.toJson());
                    authenticator.setCounter(counter);
                    return this.updater.apply(authenticator).compose(stored -> {
                        User user = User.create((JsonObject)authenticator.toJson());
                        if ((authenticator.getFlags() & 1) != 0) {
                            user.principal().put("amr", Arrays.asList("user", "swk"));
                        } else {
                            user.principal().put("amr", Collections.singletonList("swk"));
                        }
                        return Future.succeededFuture((Object)user);
                    });
                }
                catch (AttestationException | IOException | RuntimeException | NoSuchAlgorithmException e) {
                    return Future.failedFuture((Throwable)e);
                }
            }
        }
        return Future.failedFuture((String)("Cannot find authenticator with id: " + webauthn.getString("id")));
    }

    private static /* synthetic */ Future lambda$authenticate$5(Authenticator authrInfo, Void stored) {
        User user = User.create((JsonObject)authrInfo.toJson());
        if ((authrInfo.getFlags() & 1) != 0) {
            user.principal().put("amr", Arrays.asList("user", "swk"));
        } else {
            user.principal().put("amr", Collections.singletonList("swk"));
        }
        return Future.succeededFuture((Object)user);
    }
}

