/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.metadata;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MetaDataEntry
implements Shareable {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataEntry.class);
    private static final List<String> INVALID_STATUS = Arrays.asList("USER_VERIFICATION_BYPASS", "ATTESTATION_KEY_COMPROMISE", "USER_KEY_REMOTE_COMPROMISE", "USER_KEY_PHYSICAL_COMPROMISE", "REVOKED");
    private static final List<String> INFO_STATUS = Collections.singletonList("UPDATE_AVAILABLE");
    private final int version;
    private final JsonObject entry;
    private final JsonObject statement;
    private final String error;

    public MetaDataEntry(JsonObject statement) {
        if (statement == null) {
            throw new IllegalArgumentException("MetaData statement cannot be null");
        }
        this.entry = null;
        this.statement = new JsonObject(Collections.unmodifiableMap(statement.getMap()));
        this.error = null;
        this.version = statement.getInteger("schema", Integer.valueOf(2));
    }

    public MetaDataEntry(JsonObject tocEntry, JsonObject statement, String error) {
        if (tocEntry == null || statement == null) {
            throw new IllegalArgumentException("toc and statement cannot be null");
        }
        this.entry = new JsonObject(Collections.unmodifiableMap(tocEntry.getMap()));
        this.error = error;
        this.statement = new JsonObject(Collections.unmodifiableMap(statement.getMap()));
        this.version = statement.getInteger("schema", Integer.valueOf(2));
        for (Object o : this.entry.getJsonArray("statusReports")) {
            JsonObject statusReport = (JsonObject)o;
            statusReport.put("effectiveDate", (Object)LocalDate.parse(statusReport.getString("effectiveDate"), DateTimeFormatter.ISO_DATE).atStartOfDay().toInstant(ZoneOffset.UTC));
        }
    }

    public MetaDataEntry(JsonObject tocEntry, byte[] rawStatement, String error) throws NoSuchAlgorithmException {
        MessageDigest sha256;
        byte[] digest;
        if (tocEntry == null || rawStatement == null) {
            throw new IllegalArgumentException("toc and statement cannot be null");
        }
        this.entry = new JsonObject(Collections.unmodifiableMap(tocEntry.getMap()));
        this.statement = new JsonObject(Collections.unmodifiableMap(new JsonObject(Buffer.buffer((byte[])Codec.base64Decode((byte[])rawStatement))).getMap()));
        this.version = this.statement.getInteger("schema", Integer.valueOf(2));
        for (Object o : this.entry.getJsonArray("statusReports")) {
            JsonObject statusReport = (JsonObject)o;
            statusReport.put("effectiveDate", (Object)LocalDate.parse(statusReport.getString("effectiveDate"), DateTimeFormatter.ISO_DATE).atStartOfDay().toInstant(ZoneOffset.UTC));
        }
        this.error = error != null ? error : (MessageDigest.isEqual(digest = (sha256 = MessageDigest.getInstance("SHA-256")).digest(rawStatement), Codec.base64UrlDecode((String)this.entry.getString("hash"))) ? null : "MDS entry hash did not match corresponding hash in MDS TOC");
    }

    void checkValid() throws MetaDataException {
        if (this.error != null) {
            throw new MetaDataException(this.error);
        }
        if (this.entry != null) {
            Instant now = Instant.now();
            JsonArray reports = this.entry.getJsonArray("statusReports");
            for (int i = reports.size() - 1; i >= 0; --i) {
                JsonObject statusReport = reports.getJsonObject(i);
                if (!statusReport.getInstant("effectiveDate").isBefore(now)) continue;
                if (INFO_STATUS.contains(statusReport.getString("status"))) {
                    LOG.info((Object)("Software Update is available: " + this.statement.getString("description")));
                }
                if (INVALID_STATUS.contains(statusReport.getString("status"))) {
                    throw new MetaDataException("Invalid MDS status: " + statusReport.getString("status"));
                }
                return;
            }
            throw new MetaDataException("Invalid MDS statusReports");
        }
    }

    JsonObject statement() {
        return this.statement;
    }

    int version() {
        return this.version;
    }
}

