/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.camel;

import io.vertx.camel.InboundMapping;
import io.vertx.camel.OutboundMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.camel.CamelContext;

public class CamelBridgeOptions {
    private List<InboundMapping> inbound = new ArrayList<InboundMapping>();
    private List<OutboundMapping> outbound = new ArrayList<OutboundMapping>();
    private final CamelContext context;

    public CamelBridgeOptions(CamelContext context) {
        Objects.requireNonNull(context);
        this.context = context;
    }

    public CamelBridgeOptions addInboundMapping(InboundMapping mapping) {
        Objects.requireNonNull(mapping);
        this.inbound.add(mapping);
        return this;
    }

    public CamelBridgeOptions addOutboundMapping(OutboundMapping mapping) {
        this.outbound.add(mapping);
        return this;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public List<InboundMapping> getInboundMappings() {
        return this.inbound;
    }

    public List<OutboundMapping> getOutboundMappings() {
        return this.outbound;
    }
}

