/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.camel.impl;

import io.vertx.camel.CamelBridge;
import io.vertx.camel.CamelBridgeOptions;
import io.vertx.camel.CamelMapping;
import io.vertx.camel.InboundMapping;
import io.vertx.camel.OutboundMapping;
import io.vertx.camel.impl.CamelToVertxProcessor;
import io.vertx.camel.impl.FromVertxToCamelProducer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedStartupListener;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.StartupListener;

public class CamelBridgeImpl
implements CamelBridge {
    private final CamelContext camel;
    private final List<Consumer> camelConsumers = new ArrayList<Consumer>();
    private final List<Producer> camelProducers = new ArrayList<Producer>();
    private final List<MessageConsumer> vertxConsumers = new ArrayList<MessageConsumer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelBridgeImpl.class);
    private final Vertx vertx;

    public CamelBridgeImpl(final Vertx vertx, final CamelBridgeOptions options) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(options);
        this.camel = options.getCamelContext();
        Objects.requireNonNull(this.camel);
        this.vertx = vertx;
        options.getInboundMappings().forEach(this::validate);
        options.getOutboundMappings().forEach(this::validate);
        try {
            this.camel.addStartupListener((StartupListener)new ExtendedStartupListener(){

                public void onCamelContextFullyStarted(CamelContext context, boolean alreadyStarted) throws Exception {
                    for (InboundMapping inbound : options.getInboundMappings()) {
                        CamelBridgeImpl.this.createInboundBridge(vertx, inbound);
                    }
                    for (OutboundMapping outbound : options.getOutboundMappings()) {
                        CamelBridgeImpl.this.createOutboundBridge(vertx, outbound);
                    }
                }

                public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Error preparing Camel with vert.x", e);
        }
    }

    private void createOutboundBridge(Vertx vertx, OutboundMapping outbound) {
        Producer producer;
        Endpoint endpoint = this.validate(outbound);
        try {
            producer = endpoint.createProducer();
            this.camelProducers.add(producer);
        }
        catch (Exception e) {
            throw new IllegalStateException("The endpoint " + outbound.getUri() + " does not support producers", e);
        }
        LOGGER.debug((Object)("Creating Vert.x message consumer for " + outbound.getUri() + " receiving messages from " + outbound.getAddress()));
        this.vertxConsumers.add(vertx.eventBus().consumer(outbound.getAddress(), (Handler)new FromVertxToCamelProducer(vertx, producer, outbound, outbound.isBlocking(), outbound.getWorkerExecutor())));
        LOGGER.info((Object)("Created Vert.x message consumer for " + outbound.getUri() + " receiving messages from " + outbound.getAddress()));
    }

    private void createInboundBridge(Vertx vertx, InboundMapping inbound) {
        Endpoint endpoint = this.validate(inbound);
        try {
            LOGGER.debug((Object)("Creating camel consumer for " + inbound.getUri() + " sending messages to " + inbound.getAddress()));
            this.camelConsumers.add(endpoint.createConsumer((Processor)new CamelToVertxProcessor(vertx, inbound)));
        }
        catch (Exception e) {
            throw new IllegalStateException("The endpoint " + inbound.getUri() + " does not support consumers", e);
        }
        LOGGER.info((Object)("Created camel consumer for " + inbound.getUri() + " sending messages to " + inbound.getAddress()));
    }

    private Endpoint validate(CamelMapping mapping) {
        Objects.requireNonNull(mapping.getAddress(), "The vert.x event bus address must not be `null`");
        Objects.requireNonNull(mapping.getUri(), "The endpoint uri must not be `null`");
        Endpoint endpoint = this.camel.getEndpoint(mapping.getUri());
        Objects.requireNonNull(endpoint, "Cannot find the endpoint " + mapping.getUri() + " in the camel context");
        return endpoint;
    }

    @Override
    public CamelBridge start() {
        return this.start(null);
    }

    @Override
    public CamelBridge start(Handler<AsyncResult<Void>> completed) {
        this.vertx.executeBlocking(future -> {
            this.camelConsumers.stream().forEach(c -> {
                try {
                    c.start();
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                }
            });
            this.camelProducers.stream().forEach(c -> {
                try {
                    c.start();
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                }
            });
            future.complete();
        }, completed);
        return this;
    }

    @Override
    public CamelBridge stop() {
        return this.stop(null);
    }

    @Override
    public CamelBridge stop(Handler<AsyncResult<Void>> completed) {
        this.vertx.executeBlocking(future -> {
            this.camelConsumers.stream().forEach(c -> {
                try {
                    c.stop();
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                }
            });
            this.camelProducers.stream().forEach(c -> {
                try {
                    c.stop();
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                }
            });
            this.vertxConsumers.stream().forEach(MessageConsumer::unregister);
            future.complete();
        }, completed);
        return this;
    }
}

