/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.camel;

import io.vertx.camel.CamelMapping;
import io.vertx.core.WorkerExecutor;
import java.util.Objects;
import org.apache.camel.Endpoint;

public class OutboundMapping
extends CamelMapping {
    private boolean blocking = false;
    private WorkerExecutor worker;

    public static OutboundMapping fromVertx(String address) {
        Objects.requireNonNull(address);
        return new OutboundMapping().setAddress(address);
    }

    @Override
    public OutboundMapping setAddress(String address) {
        super.setAddress(address);
        return this;
    }

    @Override
    public OutboundMapping setHeadersCopy(boolean copyHeaders) {
        super.setHeadersCopy(copyHeaders);
        return this;
    }

    @Override
    public OutboundMapping setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    @Override
    public OutboundMapping setEndpoint(Endpoint endpoint) {
        super.setEndpoint(endpoint);
        return this;
    }

    public OutboundMapping toCamel(String uri) {
        return this.setUri(uri);
    }

    public OutboundMapping toCamel(Endpoint endpoint) {
        return this.setEndpoint(endpoint);
    }

    public OutboundMapping withoutHeadersCopy() {
        return this.setHeadersCopy(false);
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public OutboundMapping setBlocking(boolean blocking) {
        this.blocking = blocking;
        return this;
    }

    public WorkerExecutor getWorkerExecutor() {
        return this.worker;
    }

    public OutboundMapping setWorkerExecutor(WorkerExecutor pool) {
        this.worker = pool;
        return this;
    }
}

