/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.camel.impl;

import io.vertx.camel.OutboundMapping;
import io.vertx.camel.impl.CamelHelper;
import io.vertx.camel.impl.MultiMapHelper;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.ReplyFailure;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.util.AsyncProcessorConverterHelper;

public class FromVertxToCamelProducer
implements Handler<io.vertx.core.eventbus.Message<Object>> {
    private final Endpoint endpoint;
    private final AsyncProcessor producer;
    private final OutboundMapping outbound;
    private final boolean blocking;
    private final Vertx vertx;
    private final WorkerExecutor pool;

    public FromVertxToCamelProducer(Vertx vertx, Producer producer, OutboundMapping outbound, boolean blocking, WorkerExecutor pool) {
        this.endpoint = producer.getEndpoint();
        this.producer = AsyncProcessorConverterHelper.convert((Processor)producer);
        this.outbound = outbound;
        this.blocking = blocking;
        this.vertx = vertx;
        this.pool = pool;
    }

    public void handle(io.vertx.core.eventbus.Message<Object> vertxMessage) {
        ExchangePattern mep = vertxMessage.replyAddress() != null ? ExchangePattern.InOut : ExchangePattern.InOnly;
        Exchange exchange = this.endpoint.createExchange(mep);
        Message in = exchange.getIn();
        in.setBody(vertxMessage.body());
        if (this.outbound.isHeadersCopy()) {
            MultiMapHelper.toMap(vertxMessage.headers(), in.getHeaders());
        }
        if (this.blocking) {
            if (this.pool == null) {
                this.vertx.executeBlocking(future -> {
                    this.producer.process(exchange, (AsyncCallback)new CamelProducerCallback(exchange, vertxMessage));
                    future.complete();
                }, null);
            } else {
                this.pool.executeBlocking(future -> {
                    this.producer.process(exchange, (AsyncCallback)new CamelProducerCallback(exchange, vertxMessage));
                    future.complete();
                }, null);
            }
        } else {
            this.producer.process(exchange, (AsyncCallback)new CamelProducerCallback(exchange, vertxMessage));
        }
    }

    private static final class CamelProducerCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final io.vertx.core.eventbus.Message<Object> vertxMessage;

        public CamelProducerCallback(Exchange exchange, io.vertx.core.eventbus.Message<Object> vertxMessage) {
            this.exchange = exchange;
            this.vertxMessage = vertxMessage;
        }

        public void done(boolean done) {
            if (this.vertxMessage.replyAddress() != null) {
                if (this.exchange.getException() != null) {
                    this.vertxMessage.fail(ReplyFailure.RECIPIENT_FAILURE.toInt(), this.exchange.getException().getMessage());
                } else {
                    Message msg = this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn();
                    Object body = msg.getBody();
                    DeliveryOptions delivery = CamelHelper.getDeliveryOptions(msg, true);
                    this.vertxMessage.reply(body, delivery);
                }
            }
        }
    }
}

