/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import io.vertx.cassandra.ResultSet;
import io.vertx.cassandra.impl.Util;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResultSetImpl
implements ResultSet {
    private com.datastax.driver.core.ResultSet resultSet;
    private Vertx vertx;

    public ResultSetImpl(com.datastax.driver.core.ResultSet resultSet, Vertx vertx) {
        this.resultSet = resultSet;
        this.vertx = vertx;
    }

    @Override
    public boolean isExhausted() {
        return this.resultSet.isExhausted();
    }

    @Override
    public boolean isFullyFetched() {
        return this.resultSet.isFullyFetched();
    }

    @Override
    public int getAvailableWithoutFetching() {
        return this.resultSet.getAvailableWithoutFetching();
    }

    @Override
    public ResultSet fetchMoreResults(Handler<AsyncResult<Void>> handler) {
        Context context = this.vertx.getOrCreateContext();
        Util.handleOnContext(this.resultSet.fetchMoreResults(), context, ignore -> null, handler);
        return this;
    }

    @Override
    public ResultSet one(Handler<AsyncResult<Row>> handler) {
        if (this.getAvailableWithoutFetching() == 0 && !this.resultSet.isFullyFetched()) {
            Context context = this.vertx.getOrCreateContext();
            Util.handleOnContext(this.resultSet.fetchMoreResults(), context, ignored -> this.resultSet.one(), handler);
        } else {
            handler.handle((Object)Future.succeededFuture((Object)this.resultSet.one()));
        }
        return this;
    }

    @Override
    public ResultSet several(int amount, Handler<AsyncResult<List<Row>>> handler) {
        this.loadSeveral(amount, new ArrayList<Row>(amount), handler);
        return this;
    }

    private void loadSeveral(int remainedToAdd, List<Row> resultedList, Handler<AsyncResult<List<Row>>> handler) {
        int availableWithoutFetching = this.getAvailableWithoutFetching();
        if (remainedToAdd > 0) {
            if (availableWithoutFetching > 0 && availableWithoutFetching < remainedToAdd) {
                List<Row> rows = this.getRows(availableWithoutFetching);
                resultedList.addAll(rows);
                this.loadSeveral(remainedToAdd - rows.size(), resultedList, handler);
            } else if (availableWithoutFetching >= remainedToAdd) {
                List<Row> rows = this.getRows(remainedToAdd);
                resultedList.addAll(rows);
                handler.handle((Object)Future.succeededFuture(resultedList));
            } else if (availableWithoutFetching == 0) {
                if (this.isFullyFetched()) {
                    handler.handle((Object)Future.succeededFuture(resultedList));
                } else {
                    this.fetchMoreResults((Handler<AsyncResult<Void>>)((Handler)voidAsyncResult -> {
                        if (voidAsyncResult.succeeded()) {
                            this.loadSeveral(remainedToAdd, resultedList, handler);
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)voidAsyncResult.cause()));
                        }
                    }));
                }
            }
        } else {
            handler.handle((Object)Future.succeededFuture(resultedList));
        }
    }

    private List<Row> getRows(int amountToFetch) {
        Row row;
        ArrayList<Row> rows = new ArrayList<Row>(amountToFetch);
        for (int i = 0; i < amountToFetch && (row = this.resultSet.one()) != null; ++i) {
            rows.add(row);
        }
        return rows;
    }

    @Override
    public ResultSet all(Handler<AsyncResult<List<Row>>> handler) {
        this.loadMore(this.vertx.getOrCreateContext(), Collections.emptyList(), handler);
        return this;
    }

    private void loadMore(Context context, List<Row> loaded, Handler<AsyncResult<List<Row>>> handler) {
        int availableWithoutFetching = this.resultSet.getAvailableWithoutFetching();
        ArrayList<Row> rows = new ArrayList<Row>(loaded.size() + availableWithoutFetching);
        for (int i = 0; i < availableWithoutFetching; ++i) {
            rows.add(this.resultSet.one());
        }
        if (!this.resultSet.isFullyFetched()) {
            Util.handleOnContext(this.resultSet.fetchMoreResults(), context, ar -> {
                if (ar.succeeded()) {
                    this.loadMore(context, rows, handler);
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            });
        } else {
            handler.handle((Object)Future.succeededFuture(rows));
        }
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.resultSet.getColumnDefinitions();
    }

    @Override
    public boolean wasApplied() {
        return this.resultSet.wasApplied();
    }
}

