/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import io.vertx.cassandra.ResultSet;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;

public class ResultSetImpl
implements ResultSet {
    private final Vertx vertx;
    private final AtomicReference<AsyncResultSet> resultSetRef;

    public ResultSetImpl(AsyncResultSet resultSet, Vertx vertx) {
        this.resultSetRef = new AtomicReference<AsyncResultSet>(resultSet);
        this.vertx = vertx;
    }

    @Override
    public Future<List<Row>> all() {
        Promise promise = Promise.promise();
        this.loadMore(this.vertx.getOrCreateContext(), Collections.emptyList(), (Completable<List<Row>>)promise);
        return promise.future();
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.resultSetRef.get().getColumnDefinitions();
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.resultSetRef.get().getExecutionInfo();
    }

    @Override
    public int remaining() {
        return this.resultSetRef.get().remaining();
    }

    @Override
    public Iterable<Row> currentPage() {
        return this.resultSetRef.get().currentPage();
    }

    @Override
    public Row one() {
        return (Row)this.resultSetRef.get().one();
    }

    @Override
    public boolean hasMorePages() {
        return this.resultSetRef.get().hasMorePages();
    }

    @Override
    public Future<ResultSet> fetchNextPage() throws IllegalStateException {
        return Future.fromCompletionStage((CompletionStage)this.resultSetRef.get().fetchNextPage(), (Context)this.vertx.getOrCreateContext()).map(datastaxRS -> {
            this.resultSetRef.set((AsyncResultSet)datastaxRS);
            return this;
        });
    }

    @Override
    public boolean wasApplied() {
        return this.resultSetRef.get().wasApplied();
    }

    private void loadMore(Context context, List<Row> loaded, Completable<List<Row>> handler) {
        int availableWithoutFetching = this.resultSetRef.get().remaining();
        ArrayList<Row> rows = new ArrayList<Row>(loaded.size() + availableWithoutFetching);
        rows.addAll(loaded);
        for (int i = 0; i < availableWithoutFetching; ++i) {
            rows.add((Row)this.resultSetRef.get().one());
        }
        if (this.resultSetRef.get().hasMorePages()) {
            Future.fromCompletionStage((CompletionStage)this.resultSetRef.get().fetchNextPage(), (Context)context).onComplete(ar -> {
                if (ar.succeeded()) {
                    this.resultSetRef.set((AsyncResultSet)ar.result());
                    this.loadMore(context, rows, handler);
                } else if (handler != null) {
                    handler.fail(ar.cause());
                }
            });
        } else if (handler != null) {
            handler.succeed(rows);
        }
    }
}

