/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra;

import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.cassandra.CassandraRowStream;
import io.vertx.cassandra.ResultSet;
import io.vertx.cassandra.impl.CassandraClientImpl;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collector;

@VertxGen
public interface CassandraClient {
    public static final String DEFAULT_SHARED_CLIENT_NAME = "DEFAULT";

    public static CassandraClient create(Vertx vertx) {
        return CassandraClient.create(vertx, new CassandraClientOptions());
    }

    public static CassandraClient create(Vertx vertx, CassandraClientOptions options) {
        return new CassandraClientImpl(vertx, UUID.randomUUID().toString(), options);
    }

    public static CassandraClient createShared(Vertx vertx) {
        return CassandraClient.createShared(vertx, DEFAULT_SHARED_CLIENT_NAME);
    }

    public static CassandraClient createShared(Vertx vertx, String clientName) {
        return CassandraClient.createShared(vertx, clientName, new CassandraClientOptions());
    }

    public static CassandraClient createShared(Vertx vertx, CassandraClientOptions options) {
        return CassandraClient.createShared(vertx, DEFAULT_SHARED_CLIENT_NAME, options);
    }

    public static CassandraClient createShared(Vertx vertx, String clientName, CassandraClientOptions options) {
        return new CassandraClientImpl(vertx, clientName, options);
    }

    public boolean isConnected();

    @GenIgnore(value={"permitted-type"})
    public Future<List<Row>> executeWithFullFetch(String var1);

    @GenIgnore(value={"permitted-type"})
    public Future<List<Row>> executeWithFullFetch(Statement var1);

    public Future<ResultSet> execute(String var1);

    @GenIgnore
    public <R> Future<R> execute(String var1, Collector<Row, ?, R> var2);

    @GenIgnore(value={"permitted-type"})
    public Future<ResultSet> execute(Statement var1);

    @GenIgnore
    public <R> Future<R> execute(Statement var1, Collector<Row, ?, R> var2);

    @GenIgnore(value={"permitted-type"})
    public Future<PreparedStatement> prepare(String var1);

    @GenIgnore(value={"permitted-type"})
    public Future<PreparedStatement> prepare(SimpleStatement var1);

    public Future<CassandraRowStream> queryStream(String var1);

    @GenIgnore(value={"permitted-type"})
    public Future<CassandraRowStream> queryStream(Statement var1);

    public Future<Void> close();

    @GenIgnore(value={"permitted-type"})
    public Future<Metadata> metadata();
}

