/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import io.vertx.cassandra.CassandraClientOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import java.net.InetSocketAddress;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class CassandraClientOptions {
    public static final int DEFAULT_PORT = 9042;
    public static final String DEFAULT_HOST = "localhost";
    private final CqlSessionBuilder builder;
    private String keyspace;
    private String username;
    private String password;
    private TracingPolicy tracingPolicy;

    public CassandraClientOptions() {
        this(CqlSession.builder());
    }

    public CassandraClientOptions(CassandraClientOptions other) {
        this(other.dataStaxClusterBuilder());
        this.setKeyspace(other.getKeyspace());
        this.tracingPolicy = other.tracingPolicy;
    }

    public CassandraClientOptions(CqlSessionBuilder builder) {
        this.builder = builder;
        this.tracingPolicy = TracingPolicy.PROPAGATE;
    }

    public CassandraClientOptions(JsonObject json) {
        this();
        CassandraClientOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CassandraClientOptionsConverter.toJson(this, json);
        return json;
    }

    public CassandraClientOptions addContactPoint(InetSocketAddress address) {
        this.builder.addContactPoint(address);
        return this;
    }

    public CassandraClientOptions addContactPoint(String host, int port) {
        this.builder.addContactPoint(InetSocketAddress.createUnresolved(host, port));
        return this;
    }

    public CqlSessionBuilder dataStaxClusterBuilder() {
        return this.builder;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public CassandraClientOptions setKeyspace(String keyspace) {
        this.keyspace = keyspace;
        this.builder.withKeyspace(keyspace);
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public CassandraClientOptions setUsername(String username) {
        this.username = username;
        this.setAuth();
        return this;
    }

    private void setAuth() {
        if (this.username == null || this.password == null) {
            this.builder.withAuthProvider(null);
        } else {
            this.builder.withAuthCredentials(this.username, this.password);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public CassandraClientOptions setPassword(String password) {
        this.password = password;
        this.setAuth();
        return this;
    }

    public TracingPolicy getTracingPolicy() {
        return this.tracingPolicy;
    }

    public CassandraClientOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        this.tracingPolicy = tracingPolicy;
        return this;
    }
}

