/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra;

import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Map;

public class CassandraClientOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, CassandraClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "contactPoints": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addContactPoint((String)entry.getKey(), ((Number)entry.getValue()).intValue());
                        }
                    });
                    break;
                }
                case "keyspace": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setKeyspace((String)member.getValue());
                    break;
                }
                case "username": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUsername((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTracingPolicy(TracingPolicy.valueOf((String)((String)member.getValue())));
                }
            }
        }
    }

    static void toJson(CassandraClientOptions obj, JsonObject json) {
        CassandraClientOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(CassandraClientOptions obj, Map<String, Object> json) {
        if (obj.getKeyspace() != null) {
            json.put("keyspace", obj.getKeyspace());
        }
        if (obj.getUsername() != null) {
            json.put("username", obj.getUsername());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getTracingPolicy() != null) {
            json.put("tracingPolicy", obj.getTracingPolicy().name());
        }
    }
}

